/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.net.InetAddresses;

public class HostEntryComparator {
    private static final int MAX_NET_MASK = 128;

    public static int compare(String s1, String s2) {
        if (HostEntryComparator.isFullName(s1) && HostEntryComparator.isFullName(s2)) {
            return HostEntryComparator.netmaskCmp(s1, s2);
        }
        if (HostEntryComparator.isFullName(s1)) {
            return -1;
        }
        if (HostEntryComparator.isFullName(s2)) {
            return 1;
        }
        return HostEntryComparator.maskCmp(s1, s2);
    }

    private static int netmaskCmp(String s1, String s2) {
        int order = Integer.compare(HostEntryComparator.netmaskOf(s2), HostEntryComparator.netmaskOf(s1));
        return order != 0 ? order : HostEntryComparator.preferIp(s1, s2);
    }

    private static int preferIp(String s1, String s2) {
        String addr1 = HostEntryComparator.stripNetmask(s1);
        String addr2 = HostEntryComparator.stripNetmask(s2);
        if (InetAddresses.isInetAddress((String)addr1) && InetAddresses.isInetAddress((String)addr2)) {
            return Integer.compare(InetAddresses.forString((String)addr2).getAddress().length, InetAddresses.forString((String)addr1).getAddress().length);
        }
        if (InetAddresses.isInetAddress((String)addr1)) {
            return -1;
        }
        if (InetAddresses.isInetAddress((String)addr2)) {
            return 1;
        }
        return 0;
    }

    private static String stripNetmask(String s) {
        int i = s.indexOf(47);
        return i > 0 ? s.substring(0, i) : s;
    }

    private static int netmaskOf(String s) {
        int i = s.indexOf(47);
        return i > 0 ? Integer.parseInt(s.substring(i + 1)) : 128;
    }

    private static boolean isFullName(String s) {
        return s.indexOf(63) < 0 & s.indexOf(42) < 0;
    }

    private static int maskCmp(String s1, String s2) {
        int maskIndex1 = s1.indexOf(42);
        int maskIndex2 = s2.indexOf(42);
        return Integer.compare(maskIndex2, maskIndex1);
    }
}

