/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sts;

import ch.cyberduck.core.AsciiRandomStringService;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.aws.CustomClientConfiguration;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.ExpiredTokenException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.profile.internal.AbstractProfilesConfigFileScanner;
import com.amazonaws.auth.profile.internal.AllProfiles;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AWSSecurityTokenServiceException;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class STSCredentialsConfigurator {
    private static final Logger log = LogManager.getLogger(STSCredentialsConfigurator.class);
    private final X509TrustManager trust;
    private final X509KeyManager key;
    private final PasswordCallback prompt;

    public STSCredentialsConfigurator(X509TrustManager trust, X509KeyManager key, PasswordCallback prompt) {
        this.trust = trust;
        this.key = key;
        this.prompt = prompt;
    }

    public Credentials configure(Host host) throws LoginFailureException, LoginCanceledException {
        Credentials credentials = new Credentials(host.getCredentials());
        Local awsDirectory = LocalFactory.get((Local)LocalFactory.get(), (String)".aws");
        Local configFile = LocalFactory.get((Local)awsDirectory, (String)"config");
        Local credentialsFile = LocalFactory.get((Local)awsDirectory, (String)"credentials");
        final String profile = host.getCredentials().getUsername();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Look for profile name %s in %s and %s", profile, configFile, credentialsFile));
        }
        HashMap<String, Map<String, String>> allProfileProperties = new HashMap<String, Map<String, String>>();
        try {
            Map<String, Map<String, String>> credentialsFileProfileProperties = new ProfilesConfigFileLoaderHelper().parseProfileProperties(credentialsFile);
            allProfileProperties.putAll(credentialsFileProfileProperties);
            Map<String, Map<String, String>> configFileProfileProperties = new ProfilesConfigFileLoaderHelper().parseProfileProperties(configFile);
            for (Map.Entry<String, Map<String, String>> entry : configFileProfileProperties.entrySet()) {
                String profileName = entry.getKey();
                Map<String, String> configFileProperties = entry.getValue();
                Map credentialsFileProperties = (Map)allProfileProperties.get(profileName);
                if (credentialsFileProperties != null) {
                    configFileProperties.putAll(credentialsFileProperties);
                }
                allProfileProperties.put(profileName, configFileProperties);
            }
        }
        catch (AccessDeniedException | IOException | IllegalArgumentException e) {
            log.warn(String.format("Failure reading %s and %s", configFile, credentialsFile), e);
            return credentials;
        }
        if (allProfileProperties.isEmpty()) {
            log.warn("Missing configuration file ~/.aws/credentials or ~/.aws/config. Skip auto configuration");
            return host.getCredentials();
        }
        LinkedHashMap<String, BasicProfile> profilesByName = new LinkedHashMap<String, BasicProfile>();
        for (Map.Entry entry : allProfileProperties.entrySet()) {
            String profileName = (String)entry.getKey();
            Map properties = (Map)entry.getValue();
            profilesByName.put(profileName, new BasicProfile(profileName, properties));
        }
        Map profiles = new AllProfiles(profilesByName).getProfiles();
        Optional<Map.Entry<String, BasicProfile>> optional = profiles.entrySet().stream().filter(new Predicate<Map.Entry<String, BasicProfile>>(){

            @Override
            public boolean test(Map.Entry<String, BasicProfile> entry) {
                String profileName = entry.getKey();
                BasicProfile basicProfile = entry.getValue();
                String awsAccessIdKey = basicProfile.getAwsAccessIdKey();
                if (StringUtils.equals((CharSequence)profileName, (CharSequence)profile) || StringUtils.equals((CharSequence)awsAccessIdKey, (CharSequence)profile)) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Found matching profile %s", profile));
                    }
                    return true;
                }
                return false;
            }
        }).findFirst();
        if (optional.isPresent()) {
            AWSSecurityTokenService service;
            Map.Entry<String, Map<String, String>> entry;
            entry = optional.get();
            BasicProfile basicProfile = (BasicProfile)entry.getValue();
            if (basicProfile.isRoleBasedProfile()) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Configure credentials from role based profile %s", basicProfile.getProfileName()));
                }
                if (StringUtils.isBlank((CharSequence)basicProfile.getRoleSourceProfile())) {
                    throw new LoginFailureException(String.format("Missing source profile reference in profile %s", basicProfile.getProfileName()));
                }
                if (!profiles.containsKey(basicProfile.getRoleSourceProfile())) {
                    throw new LoginFailureException(String.format("Missing source profile with name %s", basicProfile.getRoleSourceProfile()));
                }
                BasicProfile sourceProfile = (BasicProfile)profiles.get(basicProfile.getRoleSourceProfile());
                service = this.getTokenService(host, host.getRegion(), sourceProfile.getAwsAccessIdKey(), sourceProfile.getAwsSecretAccessKey(), sourceProfile.getAwsSessionToken());
                String tokenCode = basicProfile.getProperties().containsKey("mfa_serial") ? this.prompt.prompt(host, LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), String.format("%s %s", LocaleFactory.localizedString((String)"Multi-Factor Authentication", (String)"S3"), basicProfile.getPropertyValue("mfa_serial")), new LoginOptions(host.getProtocol()).password(true).passwordPlaceholder(LocaleFactory.localizedString((String)"MFA Authentication Code", (String)"S3")).keychain(false)).getPassword() : null;
                Integer durationSeconds = basicProfile.getProperties().containsKey("duration_seconds") ? Integer.valueOf(basicProfile.getPropertyValue("duration_seconds")) : null;
                AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withExternalId(basicProfile.getRoleExternalId()).withRoleArn(basicProfile.getRoleArn()).withSerialNumber(basicProfile.getPropertyValue("mfa_serial")).withTokenCode(tokenCode).withRoleSessionName(basicProfile.getRoleSessionName() == null ? new AsciiRandomStringService().random() : basicProfile.getRoleSessionName()).withDurationSeconds(durationSeconds);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Request %s from %s", assumeRoleRequest, service));
                }
                try {
                    AssumeRoleResult assumeRoleResult = service.assumeRole(assumeRoleRequest);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Set credentials from %s", assumeRoleResult));
                    }
                    credentials.setUsername(assumeRoleResult.getCredentials().getAccessKeyId());
                    credentials.setPassword(assumeRoleResult.getCredentials().getSecretAccessKey());
                    credentials.setToken(assumeRoleResult.getCredentials().getSessionToken());
                }
                catch (AWSSecurityTokenServiceException e) {
                    throw new LoginFailureException(e.getErrorMessage(), (Throwable)e);
                }
            } else {
                Map profileProperties;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Configure credentials from basic profile %s", basicProfile.getProfileName()));
                }
                if ((profileProperties = basicProfile.getProperties()).containsKey("sso_start_url")) {
                    CachedCredential cached = this.fetchSsoCredentials(profileProperties, awsDirectory);
                    credentials.setUsername(cached.accessKey);
                    credentials.setPassword(cached.secretKey);
                    credentials.setToken(cached.sessionToken);
                } else if (StringUtils.isNotBlank((CharSequence)basicProfile.getAwsSessionToken())) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Set session token credentials from profile %s", profile));
                    }
                    credentials.setUsername(basicProfile.getAwsAccessIdKey());
                    credentials.setPassword(basicProfile.getAwsSecretAccessKey());
                    credentials.setToken(basicProfile.getAwsSessionToken());
                } else if (host.getProtocol().isTokenConfigurable()) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Get session token from credentials in profile %s", basicProfile.getProfileName()));
                    }
                    service = this.getTokenService(host, host.getRegion(), basicProfile.getAwsAccessIdKey(), basicProfile.getAwsSecretAccessKey(), basicProfile.getAwsSessionToken());
                    GetSessionTokenRequest sessionTokenRequest = new GetSessionTokenRequest();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Request %s from %s", sessionTokenRequest, service));
                    }
                    try {
                        GetSessionTokenResult sessionTokenResult = service.getSessionToken(sessionTokenRequest);
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Set credentials from %s", sessionTokenResult));
                        }
                        credentials.setUsername(sessionTokenResult.getCredentials().getAccessKeyId());
                        credentials.setPassword(sessionTokenResult.getCredentials().getSecretAccessKey());
                        credentials.setToken(sessionTokenResult.getCredentials().getSessionToken());
                    }
                    catch (AWSSecurityTokenServiceException e) {
                        throw new LoginFailureException(e.getErrorMessage(), (Throwable)e);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Set static credentials from profile %s", basicProfile.getProfileName()));
                    }
                    credentials.setUsername(basicProfile.getAwsAccessIdKey());
                    credentials.setPassword(basicProfile.getAwsSecretAccessKey());
                }
            }
        }
        return credentials;
    }

    private CachedCredential fetchSsoCredentials(Map<String, String> properties, Local awsDirectory) throws LoginFailureException {
        CachedCredential cachedCredential;
        block12: {
            String ssoStartUrl = properties.get("sso_start_url");
            String ssoAccountId = properties.get("sso_account_id");
            String ssoRoleName = properties.get("sso_role_name");
            String cacheKey = String.format("{\"accountId\":\"%s\",\"roleName\":\"%s\",\"startUrl\":\"%s\"}", ssoAccountId, ssoRoleName, ssoStartUrl);
            HashCode hashCode = Hashing.sha1().newHasher().putString((CharSequence)cacheKey, Charsets.UTF_8).hash();
            String hash = BaseEncoding.base16().lowerCase().encode(hashCode.asBytes());
            String cachedCredentialsJson = String.format("%s.json", hash);
            Local cachedCredentialsFile = LocalFactory.get((Local)LocalFactory.get((Local)LocalFactory.get((Local)awsDirectory, (String)"cli"), (String)"cache"), (String)cachedCredentialsJson);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Attempting to read SSO credentials from %s", cachedCredentialsFile.getAbsolute()));
            }
            if (!cachedCredentialsFile.exists()) {
                throw new LoginFailureException(String.format("Missing file %s with cached SSO credentials.", cachedCredentialsFile.getAbsolute()));
            }
            InputStream in = cachedCredentialsFile.getInputStream();
            try {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                CachedCredentials cached = (CachedCredentials)mapper.readValue(in, CachedCredentials.class);
                if (null == cached.credentials) {
                    throw new LoginFailureException("Failure parsing SSO credentials.");
                }
                Instant expiration = Instant.parse(cached.credentials.expiration);
                if (expiration.isBefore(Instant.now())) {
                    throw new ExpiredTokenException("Expired AWS SSO credentials.");
                }
                cachedCredential = cached.credentials;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessDeniedException | IOException e) {
                    throw new LoginFailureException("Failure retrieving SSO credentials.", e);
                }
            }
            in.close();
        }
        return cachedCredential;
    }

    protected AWSSecurityTokenService getTokenService(Host host, String region, final String accessKey, final String secretKey, final String sessionToken) {
        CustomClientConfiguration configuration = new CustomClientConfiguration(host, new ThreadLocalHostnameDelegatingTrustManager(this.trust, host.getHostname()), this.key);
        return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)(StringUtils.isBlank((CharSequence)sessionToken) ? new AWSCredentials(){

            public String getAWSAccessKeyId() {
                return accessKey;
            }

            public String getAWSSecretKey() {
                return secretKey;
            }
        } : new AWSSessionCredentials(){

            public String getAWSAccessKeyId() {
                return accessKey;
            }

            public String getAWSSecretKey() {
                return secretKey;
            }

            public String getSessionToken() {
                return sessionToken;
            }
        })))).withClientConfiguration((ClientConfiguration)configuration)).withRegion(StringUtils.isNotBlank((CharSequence)region) ? Regions.fromName((String)region) : Regions.DEFAULT_REGION)).build();
    }

    private static final class ProfilesConfigFileLoaderHelper
    extends AbstractProfilesConfigFileScanner {
        private final Map<String, Map<String, String>> allProfileProperties = new LinkedHashMap<String, Map<String, String>>();

        private ProfilesConfigFileLoaderHelper() {
        }

        public Map<String, Map<String, String>> parseProfileProperties(Local file) throws AccessDeniedException, IOException {
            if (!file.exists()) {
                return new LinkedHashMap<String, Map<String, String>>();
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Reading AWS file %s", file));
            }
            try (InputStream inputStream = file.getInputStream();){
                Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());
                try {
                    this.run(scanner);
                    LinkedHashMap<String, Map<String, String>> linkedHashMap = new LinkedHashMap<String, Map<String, String>>(this.allProfileProperties);
                    scanner.close();
                    return linkedHashMap;
                }
                catch (Throwable throwable) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }

        private String sanitizeProfile(String profileName) {
            return profileName.replaceAll("^profile ", "");
        }

        protected void onEmptyOrCommentLine(String profileName, String line) {
        }

        protected void onProfileStartingLine(String newProfileName, String line) {
            this.allProfileProperties.put(this.sanitizeProfile(newProfileName), new HashMap());
        }

        protected void onProfileEndingLine(String prevProfileName) {
        }

        protected void onProfileProperty(String profileName, String propertyKey, String propertyValue, boolean isSupportedProperty, String line) {
            Map<String, String> properties = this.allProfileProperties.get(profileName = this.sanitizeProfile(profileName));
            if (properties.containsKey(propertyKey)) {
                log.warn("Duplicate property values for [" + propertyKey + "].");
            }
            properties.put(propertyKey, propertyValue);
        }

        protected void onEndOfFile() {
        }
    }

    private static class CachedCredential {
        @JsonProperty(value="AccessKeyId")
        private String accessKey;
        @JsonProperty(value="SecretAccessKey")
        private String secretKey;
        @JsonProperty(value="SessionToken")
        private String sessionToken;
        @JsonProperty(value="Expiration")
        private String expiration;

        private CachedCredential() {
        }
    }

    private static class CachedCredentials {
        @JsonProperty(value="Credentials")
        private CachedCredential credentials;

        private CachedCredentials() {
        }
    }
}

