/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesAdapter;
import ch.cyberduck.core.s3.S3DefaultMultipartService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.utils.ServiceUtils;

public class S3WriteFeature
extends AbstractHttpWriteFeature<StorageObject>
implements Write<StorageObject> {
    private static final Logger log = LogManager.getLogger(S3WriteFeature.class);
    private final PathContainerService containerService;
    private final S3AccessControlListFeature acl;
    private final S3Session session;

    public S3WriteFeature(S3Session session, S3AccessControlListFeature acl) {
        super((AttributesAdapter)new S3AttributesAdapter());
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.acl = acl;
    }

    public HttpResponseOutputStream<StorageObject> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        final S3Object object = this.getDetails(file, status);
        DelayedHttpEntityCallable<StorageObject> command = new DelayedHttpEntityCallable<StorageObject>(){

            public StorageObject call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    RequestEntityRestStorageService client = (RequestEntityRestStorageService)((Object)S3WriteFeature.this.session.getClient());
                    Path bucket = S3WriteFeature.this.containerService.getContainer(file);
                    client.putObjectWithRequestEntityImpl(bucket.isRoot() ? "" : bucket.getName(), (StorageObject)object, (HttpEntity)entity, status.getParameters());
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Saved object %s with checksum %s", file, object.getETag()));
                    }
                }
                catch (ServiceException e) {
                    throw new S3ExceptionMappingService().map("Upload {0} failed", e, file);
                }
                if (status.getTimestamp() != null) {
                    object.addMetadata("Mtime", String.valueOf(status.getTimestamp()));
                }
                return object;
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    protected S3Object getDetails(Path file, TransferStatus status) {
        Checksum checksum;
        S3Object object = new S3Object(this.containerService.getKey(file));
        String mime = status.getMime();
        if (StringUtils.isNotBlank((CharSequence)mime)) {
            object.setContentType(mime);
        }
        if (Checksum.NONE != (checksum = status.getChecksum())) {
            switch (checksum.algorithm) {
                case md5: {
                    object.setMd5Hash(ServiceUtils.fromHex((String)checksum.hash));
                    break;
                }
                case sha256: {
                    object.addMetadata("x-amz-content-sha256", checksum.hash);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)status.getStorageClass())) {
            object.setStorageClass(status.getStorageClass());
        }
        Encryption.Algorithm encryption = status.getEncryption();
        object.setServerSideEncryptionAlgorithm(encryption.algorithm);
        object.setServerSideEncryptionKmsKeyId(encryption.key);
        for (Map.Entry m : status.getMetadata().entrySet()) {
            object.addMetadata((String)m.getKey(), (String)m.getValue());
        }
        if (!Acl.EMPTY.equals((Object)status.getAcl()) && status.getAcl().isCanned()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Set canned ACL %s for %s", status.getAcl(), file));
            }
            object.setAcl(this.acl.toAcl(status.getAcl()));
            status.setAcl(Acl.EMPTY);
        }
        if (status.getTimestamp() != null) {
            object.addMetadata("Mtime", String.valueOf(status.getTimestamp()));
        }
        if (status.getLength() != -1L) {
            object.setContentLength(status.getLength());
        }
        return object;
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        if (new HostPreferences(this.session.getHost()).getBoolean("s3.upload.multipart")) {
            try {
                S3DefaultMultipartService multipartService = new S3DefaultMultipartService(this.session);
                List<MultipartUpload> upload = multipartService.find(file);
                if (!upload.isEmpty()) {
                    Long size = 0L;
                    for (MultipartPart completed : multipartService.list(upload.iterator().next())) {
                        size = size + completed.getSize();
                    }
                    return new Write.Append(true).withStatus(status).withSize(size);
                }
            }
            catch (AccessDeniedException | InteroperabilityException e) {
                log.warn(String.format("Ignore failure listing incomplete multipart uploads. %s", e));
            }
        }
        return Write.override;
    }

    public boolean timestamp() {
        return true;
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.sha256);
    }
}

