/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.ProxyListProgressListener;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3VersionedObjectListService;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3BucketVersioningStatus;
import org.jets3t.service.model.S3Object;

public class S3VersioningFeature
implements Versioning {
    private static final Logger log = LogManager.getLogger(S3VersioningFeature.class);
    private final S3Session session;
    private final PathContainerService containerService;
    private final S3AccessControlListFeature acl;
    private final LRUCache<Path, VersioningConfiguration> cache = LRUCache.build((long)10L);

    public S3VersioningFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.acl = acl;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public void setConfiguration(Path file, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        try {
            VersioningConfiguration current = this.getConfiguration(bucket);
            if (current.isMultifactor()) {
                Credentials factor = this.getToken(prompt);
                if (configuration.isEnabled()) {
                    if (current.isEnabled()) {
                        log.debug(String.format("Versioning already enabled for bucket %s", bucket));
                    } else {
                        log.debug(String.format("Enable bucket versioning with MFA %s for %s", factor.getUsername(), bucket));
                        ((RequestEntityRestStorageService)((Object)this.session.getClient())).enableBucketVersioningWithMFA(bucket.isRoot() ? "" : bucket.getName(), factor.getUsername(), factor.getPassword());
                    }
                } else {
                    log.debug(String.format("Suspend bucket versioning with MFA %s for %s", factor.getUsername(), bucket));
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).suspendBucketVersioningWithMFA(bucket.isRoot() ? "" : bucket.getName(), factor.getUsername(), factor.getPassword());
                }
                if (configuration.isEnabled() && !configuration.isMultifactor()) {
                    log.debug(String.format("Disable MFA %s for %s", factor.getUsername(), bucket));
                    Credentials factor2 = this.getToken(prompt);
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).disableMFAForVersionedBucket(bucket.isRoot() ? "" : bucket.getName(), factor2.getUsername(), factor2.getPassword());
                }
            } else if (configuration.isEnabled()) {
                if (configuration.isMultifactor()) {
                    Credentials factor = this.getToken(prompt);
                    log.debug(String.format("Enable bucket versioning with MFA %s for %s", factor.getUsername(), bucket));
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).enableBucketVersioningWithMFA(bucket.isRoot() ? "" : bucket.getName(), factor.getUsername(), factor.getPassword());
                } else if (current.isEnabled()) {
                    log.debug(String.format("Versioning already enabled for bucket %s", bucket));
                } else {
                    log.debug(String.format("Enable bucket versioning for %s", bucket));
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).enableBucketVersioning(bucket.isRoot() ? "" : bucket.getName());
                }
            } else {
                log.debug(String.format("Susped bucket versioning for %s", bucket));
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).suspendBucketVersioning(bucket.isRoot() ? "" : bucket.getName());
            }
            this.cache.remove((Object)bucket);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Failure to write attributes of {0}", e, bucket);
        }
    }

    public VersioningConfiguration getConfiguration(Path file) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        if (this.cache.contains((Object)bucket)) {
            return (VersioningConfiguration)this.cache.get((Object)bucket);
        }
        try {
            S3BucketVersioningStatus status = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getBucketVersioningStatus(bucket.isRoot() ? "" : bucket.getName());
            if (null == status) {
                log.warn(String.format("Failure parsing versioning status for %s", bucket));
                return VersioningConfiguration.empty();
            }
            VersioningConfiguration configuration = new VersioningConfiguration(status.isVersioningEnabled(), status.isMultiFactorAuthDeleteRequired());
            this.cache.put((Object)bucket, (Object)configuration);
            return configuration;
        }
        catch (ServiceException e) {
            try {
                throw new S3ExceptionMappingService().map("Cannot read container configuration", e);
            }
            catch (AccessDeniedException l) {
                log.warn(String.format("Missing permission to read versioning configuration for %s %s", bucket, e.getMessage()));
                return VersioningConfiguration.empty();
            }
            catch (InteroperabilityException | NotfoundException i) {
                log.warn(String.format("Not supported to read versioning configuration for %s %s", bucket, e.getMessage()));
                return VersioningConfiguration.empty();
            }
        }
    }

    public void revert(Path file) throws BackgroundException {
        if (file.isFile()) {
            try {
                S3Object destination = new S3Object(this.containerService.getKey(file));
                destination.setStorageClass(file.attributes().getStorageClass());
                Encryption.Algorithm encryption = file.attributes().getEncryption();
                destination.setServerSideEncryptionAlgorithm(encryption.algorithm);
                destination.setServerSideEncryptionKmsKeyId(encryption.key);
                try {
                    Acl list = this.acl.getPermission(file);
                    if (list.isEditable()) {
                        destination.setAcl(this.acl.toAcl(list));
                    }
                }
                catch (AccessDeniedException | InteroperabilityException e) {
                    log.warn(String.format("Ignore failure %s", e));
                }
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).copyVersionedObject(file.attributes().getVersionId(), this.containerService.getContainer(file).getName(), this.containerService.getKey(file), this.containerService.getContainer(file).getName(), destination, false);
                if (file.getParent().attributes().getCustom().containsKey("delete_marker")) {
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).deleteVersionedObject(file.getParent().attributes().getVersionId(), this.containerService.getContainer(file).getName(), this.containerService.getKey(file.getParent()));
                }
            }
            catch (ServiceException e) {
                throw new S3ExceptionMappingService().map("Cannot revert file", e, file);
            }
        }
    }

    public boolean isRevertable(Path file) {
        return file.attributes().isDuplicate();
    }

    protected Credentials getToken(PasswordCallback callback) throws ConnectionCanceledException {
        return callback.prompt(this.session.getHost(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), LocaleFactory.localizedString((String)"Multi-Factor Authentication", (String)"S3"), new LoginOptions().icon(this.session.getHost().getProtocol().disk()).password(true).user(false).passwordPlaceholder(LocaleFactory.localizedString((String)"MFA Authentication Code", (String)"S3")).keychain(false));
    }

    public AttributedList<Path> list(final Path file, final ListProgressListener listener) throws BackgroundException {
        return new S3VersionedObjectListService(this.session, this.acl).list(file, (ListProgressListener)new ProxyListProgressListener(new ListProgressListener[]{new IndexedListProgressListener(){

            public void message(String message) {
                listener.message(message);
            }

            public void visit(AttributedList<Path> list, int index, Path f) {
                if (!StringUtils.equals((CharSequence)f.getName(), (CharSequence)file.getName())) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Skip file %s", f));
                    }
                    list.remove(index);
                }
            }
        }, listener})).filter((Filter)new NullFilter<Path>(){

            public boolean accept(Path f) {
                return f.attributes().isDuplicate();
            }
        });
    }
}

