/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AbstractListService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.S3Version;

public class S3VersionedObjectListService
extends S3AbstractListService
implements ListService {
    private static final Logger log = LogManager.getLogger(S3VersionedObjectListService.class);
    public static final String KEY_DELETE_MARKER = "delete_marker";
    private final PathContainerService containerService;
    private final S3Session session;
    private final S3AttributesFinderFeature attributes;
    private final Integer concurrency;
    private final boolean metadata;

    public S3VersionedObjectListService(S3Session session, S3AccessControlListFeature acl) {
        this(session, acl, new HostPreferences(session.getHost()).getInteger("s3.listing.concurrency"));
    }

    public S3VersionedObjectListService(S3Session session, S3AccessControlListFeature acl, Integer concurrency) {
        this(session, acl, concurrency, new HostPreferences(session.getHost()).getBoolean("s3.listing.metadata.enable"));
    }

    public S3VersionedObjectListService(S3Session session, S3AccessControlListFeature acl, Integer concurrency, boolean metadata) {
        super(session);
        this.session = session;
        this.attributes = new S3AttributesFinderFeature(session, acl);
        this.concurrency = concurrency;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.metadata = metadata;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"list", (int)this.concurrency);
        try {
            Object chunk;
            String prefix = this.createPrefix(directory);
            Path bucket = this.containerService.getContainer(directory);
            AttributedList children = new AttributedList();
            ArrayList<Future<Path>> folders = new ArrayList<Future<Path>>();
            String priorLastKey = null;
            String priorLastVersionId = null;
            long revision = 0L;
            String lastKey = null;
            boolean hasDirectoryPlaceholder = bucket.isRoot() || this.containerService.isContainer(directory);
            do {
                String[] prefixes;
                chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listVersionedObjectsChunked(bucket.isRoot() ? "" : bucket.getName(), prefix, String.valueOf('/'), new HostPreferences(this.session.getHost()).getInteger("s3.listing.chunksize"), priorLastKey, priorLastVersionId, false);
                for (BaseVersionOrDeleteMarker marker : chunk.getItems()) {
                    String key = URIEncoder.decode((String)marker.getKey());
                    if (String.valueOf('/').equals(PathNormalizer.normalize((String)key))) {
                        log.warn(String.format("Skipping prefix %s", key));
                        continue;
                    }
                    if (new SimplePathPredicate(PathNormalizer.compose((Path)bucket, (String)key)).test(directory)) {
                        hasDirectoryPlaceholder = true;
                        continue;
                    }
                    PathAttributes attr = new PathAttributes();
                    attr.setVersionId(marker.getVersionId());
                    if (!StringUtils.equals(lastKey, (CharSequence)key)) {
                        revision = 0L;
                    }
                    attr.setRevision(Long.valueOf(++revision));
                    attr.setDuplicate(marker.isDeleteMarker() && marker.isLatest() || !marker.isLatest());
                    if (marker.isDeleteMarker()) {
                        attr.setCustom(Collections.singletonMap(KEY_DELETE_MARKER, String.valueOf(true)));
                    }
                    attr.setModificationDate(marker.getLastModified().getTime());
                    attr.setRegion(bucket.attributes().getRegion());
                    if (marker instanceof S3Version) {
                        S3Version object = (S3Version)marker;
                        attr.setSize(object.getSize());
                        if (StringUtils.isNotBlank((CharSequence)object.getEtag())) {
                            attr.setETag(StringUtils.remove((String)object.getEtag(), (String)"\""));
                            attr.setChecksum(Checksum.parse((String)StringUtils.remove((String)object.getEtag(), (String)"\"")));
                        }
                        if (StringUtils.isNotBlank((CharSequence)object.getStorageClass())) {
                            attr.setStorageClass(object.getStorageClass());
                        }
                    }
                    Path f = new Path(directory.isDirectory() ? directory : directory.getParent(), PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.file), attr);
                    if (this.metadata) {
                        f.withAttributes(this.attributes.find(f));
                    }
                    children.add((Referenceable)f);
                    lastKey = key;
                }
                for (String common2 : prefixes = chunk.getCommonPrefixes()) {
                    if (String.valueOf('/').equals(common2)) {
                        log.warn(String.format("Skipping prefix %s", common2));
                        continue;
                    }
                    String key = PathNormalizer.normalize((String)URIEncoder.decode((String)common2));
                    if (new SimplePathPredicate(new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory))).test(directory)) continue;
                    folders.add(this.submit(pool, bucket, directory, URIEncoder.decode((String)common2)));
                }
                priorLastKey = null != chunk.getNextKeyMarker() ? URIEncoder.decode((String)chunk.getNextKeyMarker()) : null;
                priorLastVersionId = chunk.getNextVersionIdMarker();
                listener.chunk(directory, children);
            } while (priorLastKey != null);
            chunk = folders.iterator();
            while (chunk.hasNext()) {
                Future f = (Future)chunk.next();
                try {
                    children.add((Referenceable)((Path)Uninterruptibles.getUninterruptibly((Future)f)));
                }
                catch (ExecutionException e) {
                    log.warn(String.format("Listing versioned objects failed with execution failure %s", e.getMessage()));
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
            }
            listener.chunk(directory, children);
            if (!hasDirectoryPlaceholder && children.isEmpty() && (S3Session.isAwsHostname(this.session.getHost().getHostname()) ? StringUtils.isEmpty((CharSequence)RequestEntityRestStorageService.findBucketInHostname(this.session.getHost())) : Arrays.stream((chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listVersionedObjectsChunked(bucket.isRoot() ? "" : bucket.getName(), String.format("%s%s", this.createPrefix(directory.getParent()), directory.getName()), String.valueOf('/'), 1L, null, null, false)).getCommonPrefixes()).map(URIEncoder::decode).noneMatch(common -> common.equals(prefix)))) {
                throw new NotfoundException(directory.getAbsolute());
            }
            AttributedList attributedList = children;
            return attributedList;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        finally {
            pool.shutdown(false);
        }
    }

    private Future<Path> submit(ThreadPool pool, final Path bucket, final Path directory, final String common) {
        return pool.execute((Callable)new BackgroundExceptionCallable<Path>(){

            public Path call() throws BackgroundException {
                PathAttributes attr = new PathAttributes();
                attr.setRegion(bucket.attributes().getRegion());
                Path prefix = new Path(directory, PathNormalizer.name((String)common), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attr);
                try {
                    VersionOrDeleteMarkersChunk versions = ((RequestEntityRestStorageService)((Object)S3VersionedObjectListService.this.session.getClient())).listVersionedObjectsChunked(bucket.isRoot() ? "" : bucket.getName(), common, null, 1L, null, null, false);
                    if (versions.getItems().length == 1) {
                        StorageObjectsChunk unversioned;
                        BaseVersionOrDeleteMarker version = versions.getItems()[0];
                        if (URIEncoder.decode((String)version.getKey()).equals(common)) {
                            attr.setVersionId(version.getVersionId());
                            if (version.isDeleteMarker()) {
                                attr.setCustom((Map)ImmutableMap.of((Object)S3VersionedObjectListService.KEY_DELETE_MARKER, (Object)Boolean.TRUE.toString()));
                            }
                        }
                        if ((unversioned = ((RequestEntityRestStorageService)((Object)S3VersionedObjectListService.this.session.getClient())).listObjectsChunked(bucket.isRoot() ? "" : bucket.getName(), common, null, 1L, null, false)).getObjects().length == 0) {
                            attr.setDuplicate(true);
                        }
                    }
                    return prefix;
                }
                catch (ServiceException e) {
                    throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, prefix);
                }
            }
        });
    }
}

