/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.AccelerateConfig;

public class S3TransferAccelerationService
implements TransferAcceleration {
    private static final Logger log = LogManager.getLogger(S3TransferAccelerationService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final S3Session session;
    private final PathContainerService containerService;
    public static final String S3_ACCELERATE_DUALSTACK_HOSTNAME = "s3-accelerate.dualstack.amazonaws.com";

    public S3TransferAccelerationService(S3Session session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public boolean getStatus(Path file) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        try {
            return ((RequestEntityRestStorageService)((Object)this.session.getClient())).getAccelerateConfig(bucket.isRoot() ? "" : bucket.getName()).isEnabled();
        }
        catch (S3ServiceException failure) {
            throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", failure, bucket);
        }
    }

    public void setStatus(Path file, boolean enabled) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        try {
            ((RequestEntityRestStorageService)((Object)this.session.getClient())).setAccelerateConfig(bucket.isRoot() ? "" : bucket.getName(), new AccelerateConfig(enabled));
        }
        catch (S3ServiceException failure) {
            throw new S3ExceptionMappingService().map("Failure to write attributes of {0}", failure, bucket);
        }
    }

    public boolean prompt(Host bookmark, Path file, ConnectionCallback prompt) throws BackgroundException {
        try {
            prompt.warn(bookmark, LocaleFactory.localizedString((String)"Enable Amazon S3 Transfer Acceleration", (String)"S3"), LocaleFactory.localizedString((String)"Amazon S3 Transfer Acceleration makes data transfers into and out of Amazon S3 buckets faster, and only charges if there is a performance improvement.", (String)"S3"), LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), LocaleFactory.localizedString((String)"Change", (String)"Credentials"), String.format("s3.acceleration.%s", bookmark.getHostname()));
            return false;
        }
        catch (ConnectionCanceledException e) {
            this.setStatus(file, true);
            return true;
        }
    }

    public void configure(boolean enable, Path file) {
        Host host = this.session.getHost();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set S3 transfer acceleration to %s", enable));
        }
        host.setProperty("s3.transferacceleration.enable", String.valueOf(enable));
        if (enable) {
            host.setProperty("s3.bucket.virtualhost.disable", String.valueOf(false));
            host.setProperty("s3.upload.expect-continue", String.valueOf(false));
        } else {
            host.setProperty("s3.bucket.virtualhost.disable", this.preferences.getProperty("s3.bucket.virtualhost.disable"));
            host.setProperty("s3.upload.expect-continue", this.preferences.getProperty("s3.upload.expect-continue"));
        }
    }
}

