/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.shared.DefaultTouchFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import org.jets3t.service.model.StorageObject;

public class S3TouchFeature
extends DefaultTouchFeature<StorageObject> {
    private final S3Session session;

    public S3TouchFeature(S3Session session, S3AccessControlListFeature acl) {
        super((Write)new S3WriteFeature(session, acl));
        this.session = session;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        return super.touch(file, status.withChecksum(this.write.checksum(file, status).compute((InputStream)new NullInputStream(0L), status)));
    }

    public boolean isSupported(Path workdir, String filename) {
        if (StringUtils.isEmpty((CharSequence)RequestEntityRestStorageService.findBucketInHostname(this.session.getHost()))) {
            return !workdir.isRoot();
        }
        return true;
    }
}

