/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.exception.ExpiredTokenException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.sts.STSCredentialsConfigurator;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;

public class S3TokenExpiredResponseInterceptor
extends DisabledServiceUnavailableRetryStrategy {
    private static final Logger log = LogManager.getLogger(S3TokenExpiredResponseInterceptor.class);
    private static final int MAX_RETRIES = 1;
    private final X509TrustManager trust;
    private final X509KeyManager key;
    private final LoginCallback prompt;
    private final Host host;

    public S3TokenExpiredResponseInterceptor(S3Session session, X509TrustManager trust, X509KeyManager key, LoginCallback prompt) {
        this.host = session.getHost();
        this.trust = trust;
        this.key = key;
        this.prompt = prompt;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        if (executionCount <= 1) {
            switch (response.getStatusLine().getStatusCode()) {
                case 400: {
                    try {
                        if (null == response.getEntity()) break;
                        EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                        S3ServiceException failure = new S3ServiceException(response.getStatusLine().getReasonPhrase(), EntityUtils.toString((HttpEntity)response.getEntity()));
                        if (new S3ExceptionMappingService().map((ServiceException)failure) instanceof ExpiredTokenException) {
                            try {
                                this.host.setCredentials(new STSCredentialsConfigurator(this.trust, this.key, (PasswordCallback)this.prompt).configure(this.host));
                                return true;
                            }
                            catch (LoginCanceledException | LoginFailureException e) {
                                log.warn(String.format("Attempt to renew expired token failed. %s", e.getMessage()));
                            }
                        }
                        break;
                    }
                    catch (IOException e) {
                        log.warn(String.format("Failure parsing response entity from %s", response));
                    }
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn(String.format("Skip retry for response %s after %d executions", response, executionCount));
        }
        return false;
    }
}

