/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3MultipartUploadService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3SingleUploadService;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.model.StorageObject;

public class S3ThresholdUploadService
implements Upload<StorageObject> {
    private static final Logger log = LogManager.getLogger(S3ThresholdUploadService.class);
    private final S3Session session;
    private final S3AccessControlListFeature acl;
    private final Long threshold;
    private Write<StorageObject> writer;

    public S3ThresholdUploadService(S3Session session, S3AccessControlListFeature acl) {
        this(session, acl, new HostPreferences(session.getHost()).getLong("s3.upload.multipart.threshold"));
    }

    public S3ThresholdUploadService(S3Session session, S3AccessControlListFeature acl, Long threshold) {
        this.session = session;
        this.acl = acl;
        this.threshold = threshold;
        this.writer = new S3WriteFeature(session, acl);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return this.writer.append(file, status);
    }

    public StorageObject upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback prompt) throws BackgroundException {
        if (status.getLength() >= this.threshold) {
            if (!new HostPreferences(this.session.getHost()).getBoolean("s3.upload.multipart")) {
                log.warn("Multipart upload is disabled with property s3.upload.multipart");
                if (status.getLength() < new HostPreferences(this.session.getHost()).getLong("s3.upload.multipart.required.threshold")) {
                    return new S3SingleUploadService(this.session, this.writer).upload(file, local, throttle, listener, status, prompt);
                }
            }
            try {
                return new S3MultipartUploadService(this.session, this.writer, this.acl).upload(file, local, throttle, listener, status, prompt);
            }
            catch (InteroperabilityException | NotfoundException e) {
                log.warn(String.format("Failure %s using multipart upload. Fallback to single upload.", e));
                status.append(false);
                try {
                    return new S3SingleUploadService(this.session, this.writer).upload(file, local, throttle, listener, status, prompt);
                }
                catch (BackgroundException f) {
                    log.warn(String.format("Failure %s using single upload. Throw original multipart failure %s", e, e));
                    throw e;
                }
            }
        }
        return new S3SingleUploadService(this.session, this.writer).upload(file, local, throttle, listener, status, prompt);
    }

    public Upload<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

