/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3DefaultDeleteFeature;
import ch.cyberduck.core.s3.S3MultipleDeleteFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Map;

public class S3ThresholdDeleteFeature
implements Delete {
    private final S3Session session;
    private final S3AccessControlListFeature acl;

    public S3ThresholdDeleteFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.acl = acl;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        if (files.size() == 1) {
            new S3DefaultDeleteFeature(this.session).delete(files, prompt, callback);
        } else {
            new S3MultipleDeleteFeature(this.session, this.acl).delete(files, prompt, callback);
        }
    }
}

