/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3ThresholdCopyFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class S3StorageClassFeature
implements Redundancy {
    private final S3Session session;
    private final PathContainerService containerService;
    private final S3AccessControlListFeature acl;

    public S3StorageClassFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.acl = acl;
    }

    public String getDefault() {
        return new HostPreferences(this.session.getHost()).getProperty("s3.storage.class");
    }

    public Set<String> getClasses() {
        return new LinkedHashSet<String>(new HostPreferences(this.session.getHost()).getList("s3.storage.class.options"));
    }

    public String getClass(Path file) throws BackgroundException {
        if (this.containerService.isContainer(file)) {
            String key = String.format("s3.storageclass.%s", this.containerService.getContainer(file).getName());
            if (StringUtils.isNotBlank((CharSequence)new HostPreferences(this.session.getHost()).getProperty(key))) {
                return new HostPreferences(this.session.getHost()).getProperty(key);
            }
            return null;
        }
        String redundancy = new S3AttributesFinderFeature(this.session, this.acl).find(file).getStorageClass();
        if (StringUtils.isBlank((CharSequence)redundancy)) {
            return "STANDARD";
        }
        return redundancy;
    }

    public void setClass(Path file, String redundancy) throws BackgroundException {
        if (file.isFile() || file.isPlaceholder()) {
            try {
                S3ThresholdCopyFeature copy = new S3ThresholdCopyFeature(this.session);
                TransferStatus status = new TransferStatus();
                status.setLength(file.attributes().getSize());
                status.setStorageClass(redundancy);
                copy.copy(file, file, status, (ConnectionCallback)new DisabledConnectionCallback(), (StreamListener)new DisabledStreamListener());
            }
            catch (NotfoundException e) {
                if (file.isPlaceholder()) {
                    return;
                }
                throw e;
            }
        }
    }
}

