/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.model.StorageObject;

public class S3SingleUploadService
extends HttpUploadFeature<StorageObject, MessageDigest> {
    private static final Logger log = LogManager.getLogger(S3SingleUploadService.class);
    private final S3Session session;
    private Write<StorageObject> writer;

    public S3SingleUploadService(S3Session session, Write<StorageObject> writer) {
        super(writer);
        this.session = session;
        this.writer = writer;
    }

    public StorageObject upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        S3Protocol.AuthenticationHeaderSignatureVersion signatureVersion = this.session.getSignatureVersion();
        switch (signatureVersion) {
            case AWS4HMACSHA256: {
                if (HashAlgorithm.sha256.equals((Object)status.getChecksum().algorithm)) break;
                status.setChecksum(this.writer.checksum(file, status).compute(local.getInputStream(), status));
            }
        }
        try {
            return (StorageObject)super.upload(file, local, throttle, listener, status, callback);
        }
        catch (InteroperabilityException e) {
            if (!this.session.getSignatureVersion().equals((Object)signatureVersion)) {
                return this.upload(file, local, throttle, listener, status, callback);
            }
            throw e;
        }
    }

    protected InputStream decorate(InputStream in, MessageDigest digest) throws IOException {
        if (null == digest) {
            log.warn("MD5 calculation disabled");
            return super.decorate(in, null);
        }
        return new DigestInputStream(in, digest);
    }

    protected MessageDigest digest() throws IOException {
        MessageDigest digest = null;
        if (new HostPreferences(this.session.getHost()).getBoolean("queue.upload.checksum.calculate")) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return digest;
    }

    protected void post(Path file, MessageDigest digest, StorageObject response) throws BackgroundException {
        if (null != response.getServerSideEncryptionAlgorithm()) {
            log.warn(String.format("Skip checksum verification for %s with server side encryption enabled", file));
            return;
        }
        this.verify(file, digest, Checksum.parse((String)response.getETag()));
    }

    public Upload<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

