/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.auth.AWSSessionCredentialsRetriever;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cloudfront.CloudFrontDistributionConfigurationPreloader;
import ch.cyberduck.core.cloudfront.WebsiteCloudFrontDistributionConfiguration;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionRefusedException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Restore;
import ch.cyberduck.core.features.Scheduler;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.kms.KMSEncryptionFeature;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesReader;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.restore.Glacier;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3BucketHostnameTrustManager;
import ch.cyberduck.core.s3.S3BulkTransferAccelerationFeature;
import ch.cyberduck.core.s3.S3CopyFeature;
import ch.cyberduck.core.s3.S3DefaultDeleteFeature;
import ch.cyberduck.core.s3.S3DirectoryFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3FindFeature;
import ch.cyberduck.core.s3.S3LifecycleConfiguration;
import ch.cyberduck.core.s3.S3ListService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3LoggingFeature;
import ch.cyberduck.core.s3.S3MetadataFeature;
import ch.cyberduck.core.s3.S3MoveFeature;
import ch.cyberduck.core.s3.S3MultipartWriteFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3PathStyleFallbackAdapter;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.s3.S3PublicUrlProvider;
import ch.cyberduck.core.s3.S3ReadFeature;
import ch.cyberduck.core.s3.S3SearchFeature;
import ch.cyberduck.core.s3.S3StorageClassFeature;
import ch.cyberduck.core.s3.S3ThresholdCopyFeature;
import ch.cyberduck.core.s3.S3ThresholdDeleteFeature;
import ch.cyberduck.core.s3.S3ThresholdUploadService;
import ch.cyberduck.core.s3.S3TimestampFeature;
import ch.cyberduck.core.s3.S3TokenExpiredResponseInterceptor;
import ch.cyberduck.core.s3.S3TouchFeature;
import ch.cyberduck.core.s3.S3TransferAccelerationService;
import ch.cyberduck.core.s3.S3UrlProvider;
import ch.cyberduck.core.s3.S3VersioningFeature;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import ch.cyberduck.core.shared.DefaultPathHomeFeature;
import ch.cyberduck.core.shared.DelegatingHomeFeature;
import ch.cyberduck.core.shared.DelegatingSchedulerFeature;
import ch.cyberduck.core.shared.DisabledBulkFeature;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.sts.STSCredentialsConfigurator;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.CancelCallback;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.RegionEndpointCache;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.AWSSessionCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class S3Session
extends HttpSession<RequestEntityRestStorageService> {
    private static final Logger log = LogManager.getLogger(S3Session.class);
    private final PreferencesReader preferences;
    private final S3AccessControlListFeature acl;
    private final Versioning versioning;
    private final Map<Path, Set<Distribution>> distributions;
    private S3Protocol.AuthenticationHeaderSignatureVersion authenticationHeaderSignatureVersion;
    private final RegionEndpointCache regions;

    public S3Session(Host host) {
        super(host, (X509TrustManager)new S3BucketHostnameTrustManager((X509TrustManager)new DisabledX509TrustManager(), host.getHostname()), (X509KeyManager)new DefaultX509KeyManager());
        this.preferences = new HostPreferences(this.host);
        this.acl = new S3AccessControlListFeature(this);
        this.versioning = this.preferences.getBoolean("s3.versioning.enable") ? new S3VersioningFeature(this, this.acl) : null;
        this.distributions = new ConcurrentHashMap<Path, Set<Distribution>>();
        this.authenticationHeaderSignatureVersion = S3Protocol.AuthenticationHeaderSignatureVersion.getDefault(this.host.getProtocol());
        this.regions = new RegionEndpointCache();
    }

    public S3Session(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, (X509TrustManager)new S3BucketHostnameTrustManager(trust, host.getHostname()), key);
        this.preferences = new HostPreferences(this.host);
        this.acl = new S3AccessControlListFeature(this);
        this.versioning = this.preferences.getBoolean("s3.versioning.enable") ? new S3VersioningFeature(this, this.acl) : null;
        this.distributions = new ConcurrentHashMap<Path, Set<Distribution>>();
        this.authenticationHeaderSignatureVersion = S3Protocol.AuthenticationHeaderSignatureVersion.getDefault(this.host.getProtocol());
        this.regions = new RegionEndpointCache();
    }

    protected void logout() throws BackgroundException {
        try {
            ((RequestEntityRestStorageService)((Object)this.client)).shutdown();
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map(e);
        }
    }

    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return new XmlResponsesSaxParser(((RequestEntityRestStorageService)((Object)this.client)).getConfiguration(), false);
    }

    protected String getSignatureIdentifier() {
        return "AWS";
    }

    public S3Protocol.AuthenticationHeaderSignatureVersion getSignatureVersion() {
        return this.authenticationHeaderSignatureVersion;
    }

    public void setSignatureVersion(S3Protocol.AuthenticationHeaderSignatureVersion authenticationHeaderSignatureVersion) {
        this.authenticationHeaderSignatureVersion = authenticationHeaderSignatureVersion;
    }

    protected String getRestHeaderPrefix() {
        return "x-amz-";
    }

    protected String getRestMetadataPrefix() {
        return "x-amz-meta-";
    }

    protected RequestEntityRestStorageService connect(Proxy proxy, HostKeyCallback hostkey, LoginCallback prompt, CancelCallback cancel) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        if (S3Session.isAwsHostname(this.host.getHostname())) {
            configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new S3TokenExpiredResponseInterceptor(this, (X509TrustManager)new ThreadLocalHostnameDelegatingTrustManager(this.trust, this.host.getHostname()), this.key, prompt));
        }
        RequestEntityRestStorageService client = new RequestEntityRestStorageService(this, configuration);
        client.setRegionEndpointCache(this.regions);
        return client;
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        block12: {
            if (Scheme.isURL((String)this.host.getProtocol().getContext())) {
                try {
                    Credentials temporary = new AWSSessionCredentialsRetriever(this.trust, this.key, (TranscriptListener)this, this.host.getProtocol().getContext()).get();
                    ((RequestEntityRestStorageService)((Object)this.client)).setProviderCredentials((ProviderCredentials)new AWSSessionCredentials(temporary.getUsername(), temporary.getPassword(), temporary.getToken()));
                }
                catch (ConnectionRefusedException | ConnectionTimeoutException | InteroperabilityException | NotfoundException | ResolveFailedException e) {
                    log.warn(String.format("Failure to retrieve session credentials from . %s", e.getMessage()));
                    throw new LoginFailureException(e.getDetail(false), e);
                }
            } else {
                Credentials credentials = S3Session.isAwsHostname(this.host.getHostname()) ? new STSCredentialsConfigurator((X509TrustManager)new ThreadLocalHostnameDelegatingTrustManager(this.trust, this.host.getHostname()), this.key, (PasswordCallback)prompt).configure(this.host) : this.host.getCredentials();
                if (StringUtils.isNotBlank((CharSequence)credentials.getToken())) {
                    ((RequestEntityRestStorageService)((Object)this.client)).setProviderCredentials((ProviderCredentials)(credentials.isAnonymousLogin() ? null : new AWSSessionCredentials(credentials.getUsername(), credentials.getPassword(), credentials.getToken())));
                } else {
                    ((RequestEntityRestStorageService)((Object)this.client)).setProviderCredentials((ProviderCredentials)(credentials.isAnonymousLogin() ? null : new AWSCredentials(credentials.getUsername(), credentials.getPassword())));
                }
            }
            if (this.host.getCredentials().isPassed()) {
                log.warn(String.format("Skip verifying credentials with previous successful authentication event for %s", new Object[]{this}));
                return;
            }
            try {
                final Path home = new DelegatingHomeFeature(new Home[]{new DefaultPathHomeFeature(this.host)}).find();
                Location.Name location = new S3PathStyleFallbackAdapter<Location.Name>(this.host, new BackgroundExceptionCallable<Location.Name>(){

                    public Location.Name call() throws BackgroundException {
                        return new S3LocationFeature(S3Session.this, S3Session.this.regions).getLocation(home);
                    }
                }).call();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Retrieved region %s", location));
                }
                if (!Location.unknown.equals((Object)location)) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Set default region to %s determined from %s", location, home));
                    }
                    this.host.setProperty("s3.location", location.getIdentifier());
                    ((RequestEntityRestStorageService)((Object)this.client)).getConfiguration().setProperty("storage-service.default-region", location.getIdentifier());
                }
            }
            catch (AccessDeniedException | InteroperabilityException e) {
                log.warn(String.format("Failure %s querying region", e));
                Path home = new DefaultHomeFinderService((Session)this).find();
                if (!log.isDebugEnabled()) break block12;
                log.debug(String.format("Retrieved %s", home));
            }
        }
    }

    public static boolean isAwsHostname(String hostname) {
        return S3Session.isAwsHostname(hostname, true);
    }

    public static boolean isAwsHostname(String hostname, boolean cn) {
        if (cn) {
            return hostname.matches("([a-z0-9\\-]+\\.)?s3(\\.dualstack)?(\\.[a-z0-9\\-]+)?(\\.vpce)?\\.amazonaws\\.com(\\.cn)?");
        }
        return hostname.matches("([a-z0-9\\-]+\\.)?s3(\\.dualstack)?(\\.[a-z0-9\\-]+)?(\\.vpce)?\\.amazonaws\\.com");
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            final S3ListService proxy = new S3ListService(this, this.acl);
            return (T)new ListService(){

                public AttributedList<Path> list(final Path directory, final ListProgressListener listener) throws BackgroundException {
                    return new S3PathStyleFallbackAdapter<AttributedList<Path>>(S3Session.this.host, new BackgroundExceptionCallable<AttributedList<Path>>(){

                        public AttributedList<Path> call() throws BackgroundException {
                            return proxy.list(directory, listener);
                        }
                    }).call();
                }
            };
        }
        if (type == Read.class) {
            return (T)new S3ReadFeature(this);
        }
        if (type == MultipartWrite.class) {
            if (S3Session.isAwsHostname(this.host.getHostname())) {
                return (T)new S3MultipartWriteFeature(this, this.acl);
            }
            return (T)new S3MultipartWriteFeature(this, this.acl);
        }
        if (type == Write.class) {
            return (T)((Object)new S3WriteFeature(this, this.acl));
        }
        if (type == Upload.class) {
            return (T)new S3ThresholdUploadService(this, this.acl);
        }
        if (type == Directory.class) {
            final S3DirectoryFeature proxy = new S3DirectoryFeature(this, new S3WriteFeature(this, this.acl), this.acl);
            return (T)new Directory<StorageObject>(){

                public Path mkdir(final Path folder, final TransferStatus status) throws BackgroundException {
                    return new S3PathStyleFallbackAdapter<Path>(S3Session.this.host, new BackgroundExceptionCallable<Path>(){

                        public Path call() throws BackgroundException {
                            return proxy.mkdir(folder, status);
                        }
                    }).call();
                }

                public boolean isSupported(Path workdir, String name) {
                    return proxy.isSupported(workdir, name);
                }

                public Directory<StorageObject> withWriter(Write<StorageObject> writer) {
                    return proxy.withWriter((Write)writer);
                }
            };
        }
        if (type == Move.class) {
            return (T)new S3MoveFeature(this, this.acl);
        }
        if (type == Copy.class) {
            if (S3Session.isAwsHostname(this.host.getHostname())) {
                return (T)new S3ThresholdCopyFeature(this);
            }
            return (T)new S3CopyFeature(this, this.acl);
        }
        if (type == Delete.class) {
            if (S3Session.isAwsHostname(this.host.getHostname())) {
                return (T)new S3ThresholdDeleteFeature(this, this.acl);
            }
            return (T)new S3DefaultDeleteFeature(this);
        }
        if (type == AclPermission.class) {
            return (T)((Object)this.acl);
        }
        if (type == Headers.class) {
            return (T)new S3MetadataFeature(this, this.acl);
        }
        if (type == Metadata.class) {
            return (T)new S3MetadataFeature(this, this.acl);
        }
        if (type == Touch.class) {
            return (T)((Object)new S3TouchFeature(this, this.acl));
        }
        if (type == Location.class) {
            return (T)new S3LocationFeature(this, this.regions);
        }
        if (type == Versioning.class) {
            return (T)this.versioning;
        }
        if (type == Logging.class) {
            return (T)new S3LoggingFeature(this);
        }
        if (type == Lifecycle.class) {
            return (T)new S3LifecycleConfiguration(this);
        }
        if (type == Encryption.class) {
            if (S3Session.isAwsHostname(this.host.getHostname())) {
                return (T)new KMSEncryptionFeature(this, this.acl, this.trust, this.key);
            }
            return null;
        }
        if (type == Redundancy.class) {
            return (T)new S3StorageClassFeature(this, this.acl);
        }
        if (type == DistributionConfiguration.class) {
            return (T)new WebsiteCloudFrontDistributionConfiguration(this, this.trust, this.key){

                @Override
                public Distribution read(Path container, Distribution.Method method, LoginCallback prompt) throws BackgroundException {
                    Distribution distribution = super.read(container, method, prompt);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Cache distribution %s", distribution));
                    }
                    Set cached = S3Session.this.distributions.getOrDefault(container, new HashSet());
                    cached.add(distribution);
                    S3Session.this.distributions.put(container, cached);
                    return distribution;
                }
            };
        }
        if (type == UrlProvider.class) {
            return (T)new S3UrlProvider(this, this.distributions);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new S3PublicUrlProvider(this, this.acl);
        }
        if (type == Find.class) {
            return (T)new S3FindFeature(this, this.acl);
        }
        if (type == AttributesFinder.class) {
            final S3AttributesFinderFeature proxy = new S3AttributesFinderFeature(this, this.acl);
            return (T)new AttributesFinder(){

                public PathAttributes find(final Path file, final ListProgressListener listener) throws BackgroundException {
                    return new S3PathStyleFallbackAdapter<PathAttributes>(S3Session.this.host, new BackgroundExceptionCallable<PathAttributes>(){

                        public PathAttributes call() throws BackgroundException {
                            return proxy.find(file, listener);
                        }
                    }).call();
                }
            };
        }
        if (type == TransferAcceleration.class) {
            if (this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
                return (T)new S3TransferAccelerationService(this);
            }
            return null;
        }
        if (type == Bulk.class) {
            if (this.preferences.getBoolean("s3.accelerate.enable") && this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
                return (T)new S3BulkTransferAccelerationFeature(this, new S3TransferAccelerationService(this));
            }
            return (T)new DisabledBulkFeature();
        }
        if (type == Search.class) {
            return (T)new S3SearchFeature(this, this.acl);
        }
        if (type == Scheduler.class) {
            return (T)new DelegatingSchedulerFeature(new Scheduler[]{new CloudFrontDistributionConfigurationPreloader(this)});
        }
        if (type == Restore.class) {
            return (T)new Glacier(this, this.trust, this.key);
        }
        if (type == Timestamp.class) {
            if (this.preferences.getBoolean("s3.timestamp.enable")) {
                return (T)((Object)new S3TimestampFeature(this));
            }
            return null;
        }
        if (type == PathContainerService.class) {
            return (T)((Object)new S3PathContainerService(this.host));
        }
        return (T)super._getFeature(type);
    }
}

