/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3BucketListService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3Session;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class S3SearchFeature
implements Search {
    private final S3Session session;
    private final S3AccessControlListFeature acl;

    public S3SearchFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.acl = acl;
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        if (workdir.isRoot() && StringUtils.isEmpty((CharSequence)RequestEntityRestStorageService.findBucketInHostname(this.session.getHost()))) {
            AttributedList result = new AttributedList();
            AttributedList<Path> buckets = new S3BucketListService(this.session, new S3LocationFeature.S3Region(this.session.getHost().getRegion())).list(workdir, listener);
            result.addAll(S3SearchFeature.filter(regex, buckets));
            for (Path bucket : buckets) {
                result.addAll(S3SearchFeature.filter(regex, new S3ObjectListService(this.session, this.acl).list(bucket, listener, null)));
            }
            return result;
        }
        try {
            return S3SearchFeature.filter(regex, new S3ObjectListService(this.session, this.acl).list(workdir, listener, null));
        }
        catch (NotfoundException e) {
            return AttributedList.emptyList();
        }
    }

    private static AttributedList<Path> filter(Filter<Path> regex, AttributedList<Path> objects) {
        HashSet<Path> removal = new HashSet<Path>();
        for (Path f : objects) {
            if (f.getName().contains(regex.toPattern().pattern())) continue;
            removal.add(f);
        }
        objects.removeAll(removal);
        return objects;
    }

    public boolean isRecursive() {
        return true;
    }
}

