/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.input.NullInputStream;
import org.apache.http.HttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;

public class S3ReadFeature
implements Read {
    private static final Logger log = LogManager.getLogger(S3ReadFeature.class);
    private final PathContainerService containerService;
    private final S3Session session;

    public S3ReadFeature(S3Session session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            Path bucket;
            if (file.getType().contains(AbstractPath.Type.upload)) {
                return new NullInputStream(0L);
            }
            HttpRange range = HttpRange.withStatus((TransferStatus)status);
            RequestEntityRestStorageService client = (RequestEntityRestStorageService)((Object)this.session.getClient());
            HashMap<String, Object> requestHeaders = new HashMap<String, Object>();
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            if (file.attributes().getVersionId() != null) {
                requestParameters.put("versionId", file.attributes().getVersionId());
            }
            if (status.isAppend()) {
                String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add range header %s for file %s", header, file));
                }
                requestHeaders.put("Range", header);
            }
            HttpResponse response = client.performRestGet((bucket = this.containerService.getContainer(file)).isRoot() ? "" : bucket.getName(), this.containerService.getKey(file), requestParameters, requestHeaders, new int[]{206, 200});
            return new HttpMethodReleaseInputStream(response, status);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }
}

