/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import org.jets3t.service.acl.Permission;

public class S3PublicUrlProvider
implements PromptUrlProvider<Void, Void> {
    private final S3Session session;
    private final S3AccessControlListFeature acl;

    public S3PublicUrlProvider(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.acl = acl;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case download: {
                return file.isFile();
            }
        }
        return false;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        Acl permission = this.acl.getPermission(file);
        Acl.GroupUser everyone = new Acl.GroupUser("AllUsers");
        Acl.Role read = new Acl.Role(Permission.PERMISSION_READ.toString());
        if (!permission.asList().contains(new Acl.UserAndRole((Acl.User)everyone, read))) {
            permission.addAll((Acl.User)everyone, new Acl.Role[]{read});
            this.acl.setPermission(file, permission);
        }
        return new DefaultUrlProvider(this.session.getHost()).toUrl(file).find(DescriptiveUrl.Type.provider);
    }

    public DescriptiveUrl toUploadUrl(Path file, Void options, PasswordCallback callback) {
        return DescriptiveUrl.EMPTY;
    }
}

