/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.S3Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class S3PresignedUrlProvider {
    private final S3Session session;

    public S3PresignedUrlProvider(S3Session session) {
        this.session = session;
    }

    public String create(String secret, String bucket, String region, String key, String method, long expiry) {
        if (StringUtils.isBlank((CharSequence)region)) {
            switch (this.session.getSignatureVersion()) {
                case AWS4HMACSHA256: {
                    region = "us-east-1";
                }
            }
        }
        return new RestS3Service((ProviderCredentials)new AWSCredentials(StringUtils.strip((String)this.session.getHost().getCredentials().getUsername()), StringUtils.strip((String)secret))){

            public String getEndpoint() {
                return S3PresignedUrlProvider.this.session.getHost().getHostname();
            }

            protected void initializeProxy(HttpClientBuilder httpClientBuilder) {
            }
        }.createSignedUrlUsingSignatureVersion(this.session.getSignatureVersion().toString(), region, method, bucket, key, null, null, expiry / 1000L, false, true, new HostPreferences(this.session.getHost()).getBoolean("s3.bucket.virtualhost.disable"));
    }
}

