/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class S3PathStyleFallbackAdapter<R>
extends BackgroundExceptionCallable<R> {
    private static final Logger log = LogManager.getLogger(S3PathStyleFallbackAdapter.class);
    private final Host host;
    private final BackgroundExceptionCallable<R> proxy;

    public S3PathStyleFallbackAdapter(Host host, BackgroundExceptionCallable<R> proxy) {
        this.host = host;
        this.proxy = proxy;
    }

    public R call() throws BackgroundException {
        try {
            return (R)this.proxy.call();
        }
        catch (ResolveFailedException e) {
            log.warn(String.format("Failure %s resolving bucket name. Disable use of DNS bucket names", new Object[]{e}));
            this.host.setProperty("s3.bucket.virtualhost.disable", String.valueOf(true));
            return (R)this.proxy.call();
        }
    }
}

