/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AbstractListService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesAdapter;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.model.StorageObject;

public class S3ObjectListService
extends S3AbstractListService
implements ListService {
    private static final Logger log = LogManager.getLogger(S3ObjectListService.class);
    private final PathContainerService containerService;
    private final S3Session session;
    private final S3AttributesFinderFeature attributes;
    private final boolean metadata;

    public S3ObjectListService(S3Session session, S3AccessControlListFeature acl) {
        this(session, acl, new HostPreferences(session.getHost()).getBoolean("s3.listing.metadata.enable"));
    }

    public S3ObjectListService(S3Session session, S3AccessControlListFeature acl, boolean metadata) {
        super(session);
        this.session = session;
        this.attributes = new S3AttributesFinderFeature(session, acl);
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.metadata = metadata;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return this.list(directory, listener, String.valueOf('/'));
    }

    protected AttributedList<Path> list(Path directory, ListProgressListener listener, String delimiter) throws BackgroundException {
        return this.list(directory, listener, delimiter, new HostPreferences(this.session.getHost()).getInteger("s3.listing.chunksize"));
    }

    protected AttributedList<Path> list(Path directory, ListProgressListener listener, String delimiter, int chunksize) throws BackgroundException {
        try {
            StorageObjectsChunk chunk;
            String prefix = this.createPrefix(directory);
            Path bucket = this.containerService.getContainer(directory);
            AttributedList children = new AttributedList();
            String priorLastKey = null;
            boolean hasDirectoryPlaceholder = bucket.isRoot() || this.containerService.isContainer(directory);
            do {
                String[] prefixes;
                Path f;
                PathAttributes attr;
                StorageObject[] objects;
                chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listObjectsChunked(bucket.isRoot() ? "" : bucket.getName(), prefix, delimiter, chunksize, priorLastKey, false);
                for (StorageObject object : objects = chunk.getObjects()) {
                    String key = URIEncoder.decode((String)object.getKey());
                    if (String.valueOf('/').equals(PathNormalizer.normalize((String)key))) {
                        log.warn(String.format("Skipping prefix %s", key));
                        continue;
                    }
                    if (new SimplePathPredicate(PathNormalizer.compose((Path)bucket, (String)key)).test(directory)) {
                        hasDirectoryPlaceholder = true;
                        continue;
                    }
                    EnumSet<AbstractPath.Type> types = object.getKey().endsWith(String.valueOf('/')) ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file);
                    attr = new S3AttributesAdapter().toAttributes(object);
                    attr.setRegion(bucket.attributes().getRegion());
                    f = null == delimiter ? new Path(String.format("%s/%s", bucket.getAbsolute(), key), types, attr) : new Path(directory.isDirectory() ? directory : directory.getParent(), PathNormalizer.name((String)key), types, attr);
                    if (this.metadata) {
                        f.withAttributes(this.attributes.find(f));
                    }
                    children.add((Referenceable)f);
                }
                for (String common2 : prefixes = chunk.getCommonPrefixes()) {
                    if (String.valueOf('/').equals(common2)) {
                        log.warn(String.format("Skipping prefix %s", common2));
                        continue;
                    }
                    String key = PathNormalizer.normalize((String)URIEncoder.decode((String)common2));
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    attr = new PathAttributes();
                    attr.setRegion(bucket.attributes().getRegion());
                    f = null == delimiter ? new Path(String.format("%s/%s", bucket.getAbsolute(), key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attr) : new Path(directory.isDirectory() ? directory : directory.getParent(), PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attr);
                    children.add((Referenceable)f);
                }
                priorLastKey = null != chunk.getPriorLastKey() ? URIEncoder.decode((String)chunk.getPriorLastKey()) : null;
                listener.chunk(directory, children);
            } while (priorLastKey != null);
            if (!hasDirectoryPlaceholder && children.isEmpty() && (S3Session.isAwsHostname(this.session.getHost().getHostname()) ? StringUtils.isEmpty((CharSequence)RequestEntityRestStorageService.findBucketInHostname(this.session.getHost())) : Arrays.stream((chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listObjectsChunked(bucket.isRoot() ? "" : bucket.getName(), String.format("%s%s", this.createPrefix(directory.getParent()), directory.getName()), delimiter, 1L, null)).getCommonPrefixes()).map(URIEncoder::decode).noneMatch(common -> common.equals(prefix)))) {
                throw new NotfoundException(directory.getAbsolute());
            }
            return children;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }
}

