/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesAdapter;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartCompleted;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;

public class S3MultipartWriteFeature
implements MultipartWrite<StorageObject> {
    private static final Logger log = LogManager.getLogger(S3MultipartWriteFeature.class);
    private final PathContainerService containerService;
    private final S3Session session;
    private final S3AccessControlListFeature acl;

    public S3MultipartWriteFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.acl = acl;
    }

    public HttpResponseOutputStream<StorageObject> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        MultipartUpload multipart;
        final S3Object object = new S3WriteFeature(this.session, this.acl).getDetails(file, status);
        try {
            Path bucket = this.containerService.getContainer(file);
            multipart = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartStartUpload(bucket.isRoot() ? "" : bucket.getName(), object);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Multipart upload started for %s with ID %s", multipart.getObjectKey(), multipart.getUploadId()));
            }
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Upload {0} failed", e, file);
        }
        final MultipartOutputStream proxy = new MultipartOutputStream(multipart, file, status);
        return new HttpResponseOutputStream<StorageObject>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(new HostPreferences(this.session.getHost()).getInteger("s3.upload.multipart.size"))), (AttributesAdapter)new S3AttributesAdapter(), status){

            public StorageObject getStatus() {
                if (proxy.getResponse() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Received response %s", proxy.getResponse()));
                    }
                    object.setContentLength(proxy.getOffset().longValue());
                    object.setETag(proxy.getResponse().getEtag());
                    if (proxy.getResponse().getVersionId() != null) {
                        object.addMetadata("version-id", proxy.getResponse().getVersionId());
                    }
                }
                return object;
            }
        };
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public boolean timestamp() {
        return true;
    }

    private final class MultipartOutputStream
    extends OutputStream {
        private final List<MultipartPart> completed = new ArrayList<MultipartPart>();
        private final MultipartUpload multipart;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private final AtomicReference<ServiceException> canceled = new AtomicReference();
        private final AtomicReference<MultipartCompleted> response = new AtomicReference();
        private Long offset = 0L;
        private int partNumber;

        public MultipartOutputStream(MultipartUpload multipart, Path file, TransferStatus status) {
            this.multipart = multipart;
            this.file = file;
            this.overall = status;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(final byte[] content, final int off, final int len) throws IOException {
            try {
                this.completed.add((MultipartPart)new DefaultRetryCallable(S3MultipartWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<MultipartPart>(){

                    public MultipartPart call() throws BackgroundException {
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        parameters.put("uploadId", MultipartOutputStream.this.multipart.getUploadId());
                        parameters.put("partNumber", String.valueOf(++MultipartOutputStream.this.partNumber));
                        TransferStatus status = new TransferStatus().withParameters(parameters).withLength((long)len);
                        switch (S3MultipartWriteFeature.this.session.getSignatureVersion()) {
                            case AWS4HMACSHA256: {
                                status.setChecksum(ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.sha256).compute((InputStream)new ByteArrayInputStream(content, off, len), status));
                            }
                        }
                        status.setSegment(true);
                        S3Object part = new S3WriteFeature(S3MultipartWriteFeature.this.session, S3MultipartWriteFeature.this.acl).getDetails(MultipartOutputStream.this.file, status);
                        try {
                            Path bucket = S3MultipartWriteFeature.this.containerService.getContainer(MultipartOutputStream.this.file);
                            ((RequestEntityRestStorageService)((Object)S3MultipartWriteFeature.this.session.getClient())).putObjectWithRequestEntityImpl(bucket.isRoot() ? "" : bucket.getName(), (StorageObject)part, (HttpEntity)new ByteArrayEntity(content, off, len), parameters);
                        }
                        catch (ServiceException e) {
                            MultipartOutputStream.this.canceled.set(e);
                            throw new S3ExceptionMappingService().map("Upload {0} failed", e, MultipartOutputStream.this.file);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Saved object %s with checksum %s", MultipartOutputStream.this.file, part.getETag()));
                        }
                        return new MultipartPart(Integer.valueOf(MultipartOutputStream.this.partNumber), null == part.getLastModifiedDate() ? new Date(System.currentTimeMillis()) : part.getLastModifiedDate(), null == part.getETag() ? "" : part.getETag(), Long.valueOf(part.getContentLength()));
                    }
                }, (StreamCancelation)this.overall).call());
                this.offset = this.offset + (long)len;
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn(String.format("Skip double close of stream %s", this));
                    return;
                }
                if (null != this.canceled.get()) {
                    log.warn(String.format("Skip closing with previous failure %s", new Object[]{this.canceled.get()}));
                    return;
                }
                if (this.completed.isEmpty()) {
                    this.write(new byte[0]);
                }
                MultipartCompleted complete = ((RequestEntityRestStorageService)((Object)S3MultipartWriteFeature.this.session.getClient())).multipartCompleteUpload(this.multipart, this.completed);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Completed multipart upload for %s with checksum %s", complete.getObjectKey(), complete.getEtag()));
                }
                if (this.file.getType().contains(AbstractPath.Type.encrypted)) {
                    log.warn(String.format("Skip checksum verification for %s with client side encryption enabled", this.file));
                } else if (S3Session.isAwsHostname(S3MultipartWriteFeature.this.session.getHost().getHostname())) {
                    String reference;
                    StringBuilder concat = new StringBuilder();
                    for (MultipartPart part : this.completed) {
                        concat.append(part.getEtag());
                    }
                    String expected = String.format("%s-%d", ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5).compute(concat.toString()), this.completed.size());
                    if (!StringUtils.equalsIgnoreCase((CharSequence)expected, (CharSequence)(reference = StringUtils.remove((String)complete.getEtag(), (String)"\"")))) {
                        throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), this.file.getName()), MessageFormat.format("Mismatch between MD5 hash {0} of uploaded data and ETag {1} returned by the server", expected, reference));
                    }
                }
                this.response.set(complete);
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
            catch (ServiceException e) {
                throw new IOException(e.getErrorMessage(), new S3ExceptionMappingService().map(e));
            }
            finally {
                this.close.set(true);
            }
        }

        public MultipartCompleted getResponse() {
            return this.response.get();
        }

        public Long getOffset() {
            return this.offset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultipartOutputStream{");
            sb.append("multipart=").append(this.multipart);
            sb.append(", file=").append(this.file);
            sb.append('}');
            return sb.toString();
        }
    }
}

