/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.BytecountStreamListener;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesAdapter;
import ch.cyberduck.core.s3.S3DefaultMultipartService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.SegmentRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartCompleted;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;

public class S3MultipartUploadService
extends HttpUploadFeature<StorageObject, MessageDigest> {
    private static final Logger log = LogManager.getLogger(S3MultipartUploadService.class);
    private final S3Session session;
    private final PathContainerService containerService;
    private final S3DefaultMultipartService multipartService;
    private final S3AccessControlListFeature acl;
    private Write<StorageObject> writer;
    private final Long partsize;
    private final Integer concurrency;

    public S3MultipartUploadService(S3Session session, Write<StorageObject> writer, S3AccessControlListFeature acl) {
        this(session, writer, acl, new HostPreferences(session.getHost()).getLong("s3.upload.multipart.size"), new HostPreferences(session.getHost()).getInteger("s3.upload.multipart.concurrency"));
    }

    public S3MultipartUploadService(S3Session session, Write<StorageObject> writer, S3AccessControlListFeature acl, Long partsize, Integer concurrency) {
        super(writer);
        this.session = session;
        this.multipartService = new S3DefaultMultipartService(session);
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.writer = writer;
        this.acl = acl;
        this.partsize = partsize;
        this.concurrency = concurrency;
    }

    public StorageObject upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"multipart", (int)this.concurrency);
        try {
            MultipartUpload multipart = null;
            try {
                List<MultipartUpload> list;
                if (status.isAppend() && !(list = this.multipartService.find(file)).isEmpty()) {
                    multipart = list.iterator().next();
                }
            }
            catch (AccessDeniedException | InteroperabilityException e) {
                log.warn(String.format("Ignore failure listing incomplete multipart uploads. %s", e));
            }
            ArrayList<MultipartPart> completed = new ArrayList<MultipartPart>();
            if (null == multipart) {
                if (log.isInfoEnabled()) {
                    log.info("No pending multipart upload found");
                }
                S3Object object = new S3WriteFeature(this.session, this.acl).getDetails(file, status);
                Path bucket = this.containerService.getContainer(file);
                multipart = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartStartUpload(bucket.isRoot() ? "" : bucket.getName(), object);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Multipart upload started for %s with ID %s", multipart.getObjectKey(), multipart.getUploadId()));
                }
            } else if (status.isAppend()) {
                completed.addAll(this.multipartService.list(multipart));
            }
            long size = status.getOffset() + status.getLength();
            ArrayList<Future<MultipartPart>> parts = new ArrayList<Future<MultipartPart>>();
            long remaining = status.getLength();
            long offset = 0L;
            int partNumber = 1;
            while (remaining > 0L) {
                boolean bl = false;
                if (status.isAppend()) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Determine if part number %d can be skipped", partNumber));
                    }
                    for (MultipartPart c : completed) {
                        if (!c.getPartNumber().equals(partNumber)) continue;
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Skip completed part number %d", partNumber));
                        }
                        bl = true;
                        offset += c.getSize().longValue();
                        break;
                    }
                }
                if (!bl) {
                    long length = Math.min(Math.max(size / 9999L, this.partsize), remaining);
                    parts.add(this.submit(pool, file, local, throttle, listener, status, multipart, partNumber, offset, length, callback));
                    remaining -= length;
                    offset += length;
                }
                ++partNumber;
            }
            for (Future future : parts) {
                try {
                    completed.add((MultipartPart)Uninterruptibles.getUninterruptibly((Future)future));
                }
                catch (ExecutionException e) {
                    log.warn(String.format("Part upload failed with execution failure %s", e.getMessage()));
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
            }
            MultipartCompleted complete = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartCompleteUpload(multipart, completed);
            if (log.isInfoEnabled()) {
                log.info(String.format("Completed multipart upload for %s with %d parts and checksum %s", complete.getObjectKey(), completed.size(), complete.getEtag()));
            }
            if (file.getType().contains(AbstractPath.Type.encrypted)) {
                log.warn(String.format("Skip checksum verification for %s with client side encryption enabled", file));
            } else if (S3Session.isAwsHostname(this.session.getHost().getHostname())) {
                String reference;
                completed.sort((Comparator<MultipartPart>)new MultipartPart.PartNumberComparator());
                StringBuilder stringBuilder = new StringBuilder();
                for (MultipartPart part : completed) {
                    stringBuilder.append(part.getEtag());
                }
                String expected = String.format("%s-%d", ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5).compute(stringBuilder.toString()), completed.size());
                if (!StringUtils.equalsIgnoreCase((CharSequence)expected, (CharSequence)(reference = StringUtils.remove((String)complete.getEtag(), (String)"\"")))) {
                    throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), file.getName()), MessageFormat.format("Mismatch between MD5 hash {0} of uploaded data and ETag {1} returned by the server", expected, reference));
                }
            }
            StorageObject storageObject = new StorageObject(this.containerService.getKey(file));
            storageObject.setETag(complete.getEtag());
            if (status.getTimestamp() != null) {
                storageObject.addMetadata("Mtime", String.valueOf(status.getTimestamp()));
            }
            storageObject.setContentLength(size);
            status.withResponse(new S3AttributesAdapter().toAttributes(storageObject)).setComplete();
            StorageObject storageObject2 = storageObject;
            return storageObject2;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Upload {0} failed", e, file);
        }
        finally {
            pool.shutdown(false);
        }
    }

    private Future<MultipartPart> submit(ThreadPool pool, final Path file, final Local local, final BandwidthThrottle throttle, StreamListener listener, final TransferStatus overall, final MultipartUpload multipart, final int partNumber, final long offset, final long length, final ConnectionCallback callback) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, file, offset, length));
        }
        final BytecountStreamListener counter = new BytecountStreamListener(listener);
        return pool.execute((Callable)new SegmentRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<MultipartPart>(){

            public MultipartPart call() throws BackgroundException {
                overall.validate();
                TransferStatus status = new TransferStatus().withLength(length).withOffset(offset);
                HashMap<String, String> requestParameters = new HashMap<String, String>();
                requestParameters.put("uploadId", multipart.getUploadId());
                requestParameters.put("partNumber", String.valueOf(partNumber));
                status.setParameters(requestParameters);
                status.setPart(Integer.valueOf(partNumber));
                status.setHeader(overall.getHeader());
                switch (S3MultipartUploadService.this.session.getSignatureVersion()) {
                    case AWS4HMACSHA256: {
                        status.setChecksum(S3MultipartUploadService.this.writer.checksum(file, status).compute(local.getInputStream(), status));
                    }
                }
                status.setSegment(true);
                StorageObject part = (StorageObject)S3MultipartUploadService.super.upload(file, local, throttle, (StreamListener)counter, status, (StreamCancelation)overall, (StreamProgress)status, callback);
                if (log.isInfoEnabled()) {
                    log.info(String.format("Received response %s for part number %d", part, partNumber));
                }
                return new MultipartPart(Integer.valueOf(partNumber), null == part.getLastModifiedDate() ? new Date(System.currentTimeMillis()) : part.getLastModifiedDate(), null == part.getETag() ? "" : part.getETag(), Long.valueOf(part.getContentLength()));
            }
        }, (StreamCancelation)overall, counter));
    }

    public Upload<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

