/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3CopyFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartCompleted;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Object;

public class S3MultipartCopyFeature
extends S3CopyFeature {
    private static final Logger log = LogManager.getLogger(S3MultipartCopyFeature.class);
    private final S3Session session;
    private final PathContainerService containerService;
    private final ThreadPool pool;
    private final Long partsize;

    public S3MultipartCopyFeature(S3Session session, S3AccessControlListFeature acl) {
        super(session, acl);
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.pool = ThreadPoolFactory.get((String)"multipart", (int)new HostPreferences(session.getHost()).getInteger("s3.upload.multipart.concurrency"));
        this.partsize = new HostPreferences(session.getHost()).getLong("s3.copy.multipart.size");
    }

    @Override
    protected String copy(Path source, S3Object destination, TransferStatus status, StreamListener listener) throws BackgroundException {
        try {
            long size;
            ArrayList<MultipartPart> completed = new ArrayList<MultipartPart>();
            MultipartUpload multipart = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartStartUpload(destination.getBucketName(), destination);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Multipart upload started for %s with ID %s", multipart.getObjectKey(), multipart.getUploadId()));
            }
            long remaining = size = status.getLength();
            long offset = 0L;
            ArrayList<Future<MultipartPart>> parts = new ArrayList<Future<MultipartPart>>();
            int partNumber = 1;
            while (remaining > 0L) {
                long l = Math.min(Math.max(size / 10000L, this.partsize), remaining);
                parts.add(this.submit(source, multipart, partNumber, offset, l));
                remaining -= l;
                offset += l;
                ++partNumber;
            }
            for (Future future : parts) {
                try {
                    MultipartPart part = (MultipartPart)Uninterruptibles.getUninterruptibly((Future)future);
                    completed.add(part);
                    listener.sent(part.getSize().longValue());
                }
                catch (ExecutionException e) {
                    log.warn(String.format("Part upload failed with execution failure %s", e.getMessage()));
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
            }
            MultipartCompleted complete = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartCompleteUpload(multipart, completed);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Completed multipart upload for %s with checksum %s", complete.getObjectKey(), complete.getEtag()));
            }
            String string = complete.getVersionId();
            return string;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot copy {0}", e, source);
        }
        finally {
            this.pool.shutdown(false);
        }
    }

    private Future<MultipartPart> submit(final Path source, final MultipartUpload multipart, final int partNumber, final long offset, final long length) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, source, offset, length));
        }
        return this.pool.execute((Callable)new Callable<MultipartPart>(){

            @Override
            public MultipartPart call() throws BackgroundException {
                try {
                    HttpRange range = HttpRange.byLength((long)offset, (long)length);
                    Path bucket = S3MultipartCopyFeature.this.containerService.getContainer(source);
                    MultipartPart part = ((RequestEntityRestStorageService)((Object)S3MultipartCopyFeature.this.session.getClient())).multipartUploadPartCopy(multipart, partNumber, bucket.isRoot() ? "" : bucket.getName(), S3MultipartCopyFeature.this.containerService.getKey(source), null, null, null, null, range.getStart(), range.getEnd(), source.attributes().getVersionId());
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Received response %s for part number %d", part, partNumber));
                    }
                    return new MultipartPart(Integer.valueOf(partNumber), null == part.getLastModified() ? new Date(System.currentTimeMillis()) : part.getLastModified(), null == part.getEtag() ? "" : part.getEtag(), part.getSize());
                }
                catch (S3ServiceException e) {
                    throw new S3ExceptionMappingService().map("Cannot copy {0}", e, source);
                }
            }
        });
    }
}

