/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3DefaultDeleteFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3ThresholdCopyFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;

public class S3MoveFeature
implements Move {
    private static final Logger log = LogManager.getLogger(S3MoveFeature.class);
    private final PathContainerService containerService;
    private final S3Session session;
    private final S3AccessControlListFeature accessControlListFeature;
    private final Delete delete;

    public S3MoveFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.accessControlListFeature = acl;
        this.delete = new S3DefaultDeleteFeature(session);
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public Path move(Path source, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        Path copy;
        if (source.attributes().getCustom().containsKey("delete_marker")) {
            copy = new Path(renamed);
            copy.attributes().setVersionId(null);
            this.delete.delete(Collections.singletonMap(copy, status), (PasswordCallback)connectionCallback, callback);
            try {
                Path bucket = this.containerService.getContainer(renamed);
                VersionOrDeleteMarkersChunk marker = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listVersionedObjectsChunked(bucket.isRoot() ? "" : bucket.getName(), this.containerService.getKey(renamed), String.valueOf('/'), 1L, null, null, false);
                if (marker.getItems().length != 1) {
                    throw new NotfoundException(String.format("Unable to find delete marker %s", renamed.getName()));
                }
                BaseVersionOrDeleteMarker markerObject = marker.getItems()[0];
                copy.attributes().withVersionId(markerObject.getVersionId()).setCustom(Collections.singletonMap("delete_marker", Boolean.TRUE.toString()));
                this.delete.delete(Collections.singletonMap(source, status), (PasswordCallback)connectionCallback, callback);
            }
            catch (ServiceException e) {
                throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, renamed);
            }
        }
        try {
            copy = new S3ThresholdCopyFeature(this.session, this.accessControlListFeature).copy(source, renamed, status.withLength(source.attributes().getSize()), connectionCallback, (StreamListener)new DisabledStreamListener());
            this.delete.delete(Collections.singletonMap(new Path(source).withAttributes(new PathAttributes(source.attributes()).withVersionId(null)), status), (PasswordCallback)connectionCallback, callback);
        }
        catch (NotfoundException e) {
            if (source.getType().contains(AbstractPath.Type.placeholder)) {
                copy = ((Directory)this.session.getFeature(Directory.class)).mkdir(renamed, new TransferStatus().withRegion(source.attributes().getRegion()));
            }
            throw e;
        }
        return copy;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source);
    }
}

