/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.StorageObject;

public class S3MetadataFeature
implements Headers {
    private static final Logger log = LogManager.getLogger(S3MetadataFeature.class);
    private final S3Session session;
    private final PathContainerService containerService;
    private final S3AccessControlListFeature acl;

    public S3MetadataFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.acl = acl;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public Map<String, String> getDefault(Local local) {
        return new HostPreferences(this.session.getHost()).getMap("s3.metadata.default");
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        return new S3AttributesFinderFeature(this.session, this.acl).find(file).getMetadata();
    }

    public void setMetadata(Path file, TransferStatus status) throws BackgroundException {
        if (file.isFile() || file.isPlaceholder()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Write metadata %s for file %s", status, file));
            }
            try {
                Encryption encryptionFeature;
                StorageObject target = new StorageObject(this.containerService.getKey(file));
                target.replaceAllMetadata(new HashMap(status.getMetadata()));
                if (status.getTimestamp() != null) {
                    target.addMetadata("Mtime", String.valueOf(status.getTimestamp()));
                }
                try {
                    Acl list = this.acl.getPermission(file);
                    if (list.isEditable()) {
                        target.setAcl(this.acl.toAcl(list));
                    }
                }
                catch (AccessDeniedException | InteroperabilityException e) {
                    log.warn(String.format("Ignore failure %s", e));
                }
                Redundancy storageClassFeature = (Redundancy)this.session.getFeature(Redundancy.class);
                if (storageClassFeature != null) {
                    target.setStorageClass(storageClassFeature.getClass(file));
                }
                if ((encryptionFeature = (Encryption)this.session.getFeature(Encryption.class)) != null) {
                    Encryption.Algorithm encryption = encryptionFeature.getEncryption(file);
                    target.setServerSideEncryptionAlgorithm(encryption.algorithm);
                    target.setServerSideEncryptionKmsKeyId(encryption.key);
                }
                Path bucket = this.containerService.getContainer(file);
                Map metadata = ((RequestEntityRestStorageService)((Object)this.session.getClient())).updateObjectMetadata(bucket.isRoot() ? "" : bucket.getName(), target);
                if (metadata.containsKey("version-id")) {
                    file.attributes().setVersionId(metadata.get("version-id").toString());
                }
            }
            catch (ServiceException e) {
                BackgroundException failure = new S3ExceptionMappingService().map("Failure to write attributes of {0}", e, file);
                if (file.isPlaceholder() && failure instanceof NotfoundException) {
                    return;
                }
                throw failure;
            }
        }
    }
}

