/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.logging.LoggingConfiguration;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3BucketListService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3Session;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3BucketLoggingStatus;
import org.jets3t.service.model.StorageBucketLoggingStatus;

public class S3LoggingFeature
implements Logging {
    private static final Logger log = LogManager.getLogger(S3LoggingFeature.class);
    private final S3Session session;
    private final PathContainerService containerService;

    public S3LoggingFeature(S3Session session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public LoggingConfiguration getConfiguration(Path file) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        if (file.getType().contains(AbstractPath.Type.upload)) {
            return LoggingConfiguration.empty();
        }
        try {
            StorageBucketLoggingStatus status = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getBucketLoggingStatusImpl(bucket.isRoot() ? "" : bucket.getName());
            if (null == status) {
                log.warn(String.format("Failure parsing logging status for %s", bucket));
                return LoggingConfiguration.empty();
            }
            LoggingConfiguration configuration = new LoggingConfiguration(status.isLoggingEnabled(), status.getTargetBucketName());
            try {
                configuration.setContainers(new S3BucketListService(this.session, new S3LocationFeature.S3Region(this.session.getHost().getRegion())).list(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)), (ListProgressListener)new DisabledListProgressListener()).toList());
            }
            catch (AccessDeniedException | InteroperabilityException e) {
                log.warn(String.format("Failure listing buckets. %s", e.getMessage()));
                configuration.setContainers(Collections.singletonList(bucket));
            }
            return configuration;
        }
        catch (ServiceException e) {
            try {
                throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            }
            catch (AccessDeniedException | InteroperabilityException l) {
                log.warn(String.format("Missing permission to read logging configuration for %s %s", bucket.getName(), e.getMessage()));
                return LoggingConfiguration.empty();
            }
        }
    }

    public void setConfiguration(Path file, LoggingConfiguration configuration) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        try {
            S3BucketLoggingStatus status = new S3BucketLoggingStatus(StringUtils.isNotBlank((CharSequence)configuration.getLoggingTarget()) ? configuration.getLoggingTarget() : (bucket.isRoot() ? "" : bucket.getName()), null);
            if (configuration.isEnabled()) {
                status.setLogfilePrefix(new HostPreferences(this.session.getHost()).getProperty("s3.logging.prefix"));
            }
            ((RequestEntityRestStorageService)((Object)this.session.getClient())).setBucketLoggingStatus(bucket.getName(), status, true);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

