/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.lifecycle.LifecycleConfiguration;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.LifecycleConfig;

public class S3LifecycleConfiguration
implements Lifecycle {
    private static final Logger log = LogManager.getLogger(S3LifecycleConfiguration.class);
    private final S3Session session;
    private final PathContainerService containerService;

    public S3LifecycleConfiguration(S3Session session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public void setConfiguration(Path file, LifecycleConfiguration configuration) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        try {
            if (configuration.getTransition() != null || configuration.getExpiration() != null) {
                LifecycleConfig config = new LifecycleConfig();
                LifecycleConfig.Rule rule = config.newRule(String.format("%s-%s", PreferencesFactory.get().getProperty("application.name"), new AlphanumericRandomStringService().random()), "", Boolean.valueOf(true));
                if (configuration.getTransition() != null) {
                    LifecycleConfig.Transition transition = rule.newTransition();
                    transition.setDays(configuration.getTransition());
                    transition.setStorageClass(new HostPreferences(this.session.getHost()).getProperty("s3.lifecycle.transition.class"));
                }
                if (configuration.getExpiration() != null) {
                    LifecycleConfig.Expiration expiration = rule.newExpiration();
                    expiration.setDays(configuration.getExpiration());
                }
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).setLifecycleConfig(bucket.isRoot() ? "" : bucket.getName(), config);
            } else {
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).deleteLifecycleConfig(bucket.isRoot() ? "" : bucket.getName());
            }
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Failure to write attributes of {0}", e, bucket);
        }
    }

    public LifecycleConfiguration getConfiguration(Path file) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        if (file.getType().contains(AbstractPath.Type.upload)) {
            return LifecycleConfiguration.empty();
        }
        try {
            LifecycleConfig status = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getLifecycleConfig(bucket.isRoot() ? "" : bucket.getName());
            if (null == status) {
                log.warn(String.format("Failure parsing lifecycle config for %s", bucket));
                return LifecycleConfiguration.empty();
            }
            Integer transition = null;
            Integer expiration = null;
            Object storageClass = null;
            for (LifecycleConfig.Rule rule : status.getRules()) {
                if (!StringUtils.isBlank((CharSequence)rule.getPrefix())) continue;
                if (rule.getTransition() != null) {
                    transition = rule.getTransition().getDays();
                }
                if (rule.getExpiration() == null) continue;
                expiration = rule.getExpiration().getDays();
            }
            return new LifecycleConfiguration(transition, expiration);
        }
        catch (ServiceException e) {
            try {
                throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, bucket);
            }
            catch (AccessDeniedException | InteroperabilityException l) {
                log.warn(String.format("Missing permission to read lifecycle configuration for %s %s", bucket, e.getMessage()));
                return LifecycleConfiguration.empty();
            }
        }
    }
}

