/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.http.ExtendedHttpRequestRetryHandler;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import java.io.IOException;
import java.net.URI;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.SignatureUtils;

public class S3HttpRequestRetryHandler
extends ExtendedHttpRequestRetryHandler {
    private static final Logger log = LogManager.getLogger(S3HttpRequestRetryHandler.class);
    private static final int MAX_RETRIES = 1;
    private final Host host;
    private final JetS3tRequestAuthorizer authorizer;

    public S3HttpRequestRetryHandler(Host host, JetS3tRequestAuthorizer authorizer, int retryCount) {
        super(retryCount);
        this.host = host;
        this.authorizer = authorizer;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Object attribute;
        if (executionCount <= 1 && super.retryRequest(exception, executionCount, context) && (attribute = context.getAttribute("http.request")) instanceof HttpUriRequest) {
            HttpUriRequest request = (HttpUriRequest)attribute;
            if (log.isWarnEnabled()) {
                log.warn(String.format("Retrying request %s", request));
            }
            try {
                String region = SignatureUtils.awsRegionForRequest((URI)request.getURI());
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Determined region %s from URI %s", region, request.getURI()));
                }
                String bucketName = ServiceUtils.findBucketNameInHostOrPath((URI)request.getURI(), (String)RequestEntityRestStorageService.createRegionSpecificEndpoint(this.host, region));
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Determined bucket %s from request %s", bucketName, request));
                }
                this.authorizer.authorizeHttpRequest(bucketName, request, context, null);
                return true;
            }
            catch (ServiceException e) {
                log.warn("Unable to generate updated authorization string for retried request", (Throwable)e);
            }
        }
        return false;
    }
}

