/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.CancellingListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;

public class S3FindFeature
implements Find {
    private static final Logger log = LogManager.getLogger(S3FindFeature.class);
    private final PathContainerService containerService;
    private final S3Session session;
    private final S3AccessControlListFeature acl;
    private final S3AttributesFinderFeature attributes;

    public S3FindFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.acl = acl;
        this.attributes = new S3AttributesFinderFeature(session, acl);
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public boolean find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            if (this.containerService.isContainer(file)) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Test if bucket %s is accessible", file));
                    }
                    return ((RequestEntityRestStorageService)((Object)this.session.getClient())).isBucketAccessible(this.containerService.getContainer(file).getName());
                }
                catch (ServiceException e) {
                    throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
                }
            }
            if (file.isFile() || file.isPlaceholder()) {
                this.attributes.find(file, listener);
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Search for common prefix %s", file));
            }
            try {
                new S3ObjectListService(this.session, this.acl).list(file, (ListProgressListener)new CancellingListProgressListener(), String.valueOf('/'), 1);
                return true;
            }
            catch (ListCanceledException l) {
                return true;
            }
            catch (NotfoundException e) {
                throw e;
            }
        }
        catch (NotfoundException e) {
            return false;
        }
        catch (RetriableAccessDeniedException e) {
            throw e;
        }
        catch (AccessDeniedException e) {
            return true;
        }
    }
}

