/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3ThresholdCopyFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class S3EncryptionFeature
implements Encryption {
    private final PathContainerService containerService;
    private final S3Session session;
    private final S3AccessControlListFeature acl;
    public static final Encryption.Algorithm SSE_AES256 = new Encryption.Algorithm("AES256", null){

        public String getDescription() {
            return "SSE-S3 (AES-256)";
        }
    };

    public S3EncryptionFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.acl = acl;
    }

    public Set<Encryption.Algorithm> getKeys(Path file, LoginCallback prompt) throws BackgroundException {
        return new HashSet<Encryption.Algorithm>(Arrays.asList(Encryption.Algorithm.NONE, SSE_AES256));
    }

    public Encryption.Algorithm getDefault(Path file) {
        String key = String.format("s3.encryption.key.%s", this.containerService.getContainer(file).getName());
        if (StringUtils.isNotBlank((CharSequence)new HostPreferences(this.session.getHost()).getProperty(key))) {
            return Encryption.Algorithm.fromString((String)new HostPreferences(this.session.getHost()).getProperty(key));
        }
        String setting = new HostPreferences(this.session.getHost()).getProperty("s3.encryption.algorithm");
        if (StringUtils.equals((CharSequence)S3EncryptionFeature.SSE_AES256.algorithm, (CharSequence)setting)) {
            return SSE_AES256;
        }
        return Encryption.Algorithm.NONE;
    }

    public Encryption.Algorithm getEncryption(Path file) throws BackgroundException {
        return new S3AttributesFinderFeature(this.session, this.acl).find(file).getEncryption();
    }

    public void setEncryption(Path file, Encryption.Algorithm setting) throws BackgroundException {
        if (this.containerService.isContainer(file)) {
            String key = String.format("s3.encryption.key.%s", this.containerService.getContainer(file).getName());
            PreferencesFactory.get().setProperty(key, setting.toString());
        }
        if (file.isFile() || file.isPlaceholder()) {
            try {
                S3ThresholdCopyFeature copy = new S3ThresholdCopyFeature(this.session);
                TransferStatus status = new TransferStatus();
                status.setEncryption(setting);
                status.setLength(file.attributes().getSize());
                copy.copy(file, file, status, (ConnectionCallback)new DisabledConnectionCallback(), (StreamListener)new DisabledStreamListener());
            }
            catch (NotfoundException e) {
                if (file.isPlaceholder()) {
                    return;
                }
                throw e;
            }
        }
    }
}

