/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3BucketCreateService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3TouchFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.util.EnumSet;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.utils.ServiceUtils;

public class S3DirectoryFeature
implements Directory<StorageObject> {
    private static final String MIMETYPE = "application/x-directory";
    private final S3Session session;
    private final S3AccessControlListFeature acl;
    private final PathContainerService containerService;
    private Write<StorageObject> writer;

    public S3DirectoryFeature(S3Session session, Write<StorageObject> writer, S3AccessControlListFeature acl) {
        this.session = session;
        this.writer = writer;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.acl = acl;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        if (this.containerService.isContainer(folder)) {
            S3BucketCreateService service = new S3BucketCreateService(this.session);
            service.create(folder, StringUtils.isBlank((CharSequence)status.getRegion()) ? new S3LocationFeature(this.session, ((RequestEntityRestStorageService)((Object)this.session.getClient())).getRegionEndpointCache()).getDefault().getIdentifier() : status.getRegion());
            return folder;
        }
        EnumSet<AbstractPath.Type> type = EnumSet.copyOf(folder.getType());
        type.add(AbstractPath.Type.placeholder);
        return new S3TouchFeature(this.session, this.acl).withWriter(this.writer).touch(folder.withType(type), status.withMime(MIMETYPE).withChecksum(this.writer.checksum(folder, status).compute((InputStream)new NullInputStream(0L), status)));
    }

    public boolean isSupported(Path workdir, String name) {
        if (StringUtils.isEmpty((CharSequence)RequestEntityRestStorageService.findBucketInHostname(this.session.getHost())) && workdir.isRoot() && StringUtils.isNotBlank((CharSequence)name)) {
            return ServiceUtils.isBucketNameValidDNSName((String)name);
        }
        return true;
    }

    public S3DirectoryFeature withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

