/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3MultipartService;
import ch.cyberduck.core.s3.S3Session;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.MultipartUploadChunk;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;

public class S3DefaultMultipartService
implements S3MultipartService {
    public static final int MAXIMUM_UPLOAD_PARTS = 10000;
    private static final Logger log = LogManager.getLogger(S3DefaultMultipartService.class);
    private final S3Session session;
    private final PathContainerService containerService;

    public S3DefaultMultipartService(S3Session session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    @Override
    public List<MultipartUpload> find(Path file) throws BackgroundException {
        boolean isTruncated;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Finding multipart uploads for %s", file));
        }
        ArrayList<MultipartUpload> uploads = new ArrayList<MultipartUpload>();
        String nextUploadIdMarker = null;
        String nextKeyMarker = null;
        do {
            MultipartUploadChunk chunk;
            Path bucket = this.containerService.getContainer(file);
            try {
                chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartListUploadsChunked(bucket.isRoot() ? "" : bucket.getName(), this.containerService.getKey(file), String.valueOf('/'), nextKeyMarker, nextUploadIdMarker, null, false);
            }
            catch (S3ServiceException e) {
                BackgroundException failure = new S3ExceptionMappingService().map("Upload {0} failed", e, file);
                if (failure instanceof NotfoundException) {
                    return Collections.emptyList();
                }
                if (failure instanceof InteroperabilityException) {
                    return Collections.emptyList();
                }
                throw failure;
            }
            uploads.addAll(Arrays.asList(chunk.getUploads()));
            if (log.isInfoEnabled()) {
                log.info(String.format("Found %d previous multipart uploads for %s", uploads.size(), file));
            }
            uploads.sort(new Comparator<MultipartUpload>(){

                @Override
                public int compare(MultipartUpload o1, MultipartUpload o2) {
                    return -o1.getInitiatedDate().compareTo(o2.getInitiatedDate());
                }
            });
            nextKeyMarker = chunk.getPriorLastKey();
            nextUploadIdMarker = chunk.getPriorLastIdMarker();
            boolean bl = isTruncated = !chunk.isListingComplete();
        } while (isTruncated && nextUploadIdMarker != null);
        if (log.isInfoEnabled()) {
            for (MultipartUpload upload : uploads) {
                log.info(String.format("Found multipart upload %s for %s", upload, file));
            }
        }
        return uploads;
    }

    @Override
    public List<MultipartPart> list(MultipartUpload upload) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("List completed parts of %s", upload.getUploadId()));
        }
        try {
            return ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartListParts(upload);
        }
        catch (S3ServiceException e) {
            throw new S3ExceptionMappingService().map(MessageFormat.format("Upload {0} failed", upload.getObjectKey()), e);
        }
    }

    @Override
    public void delete(MultipartUpload upload) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Delete multipart upload %s", upload.getUploadId()));
        }
        try {
            ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartAbortUpload(upload);
        }
        catch (S3ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot delete {0}", e, new Path(new Path(PathNormalizer.normalize((String)upload.getBucketName()), EnumSet.of(AbstractPath.Type.directory)), upload.getObjectKey(), EnumSet.of(AbstractPath.Type.file)));
        }
    }
}

