/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3DefaultMultipartService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3MultipartService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartUpload;

public class S3DefaultDeleteFeature
implements Delete {
    private static final Logger log = LogManager.getLogger(S3DefaultDeleteFeature.class);
    private final S3Session session;
    private final PathContainerService containerService;
    private final S3MultipartService multipartService;

    public S3DefaultDeleteFeature(S3Session session) {
        this(session, new S3DefaultMultipartService(session));
    }

    public S3DefaultDeleteFeature(S3Session session, S3MultipartService multipartService) {
        this.session = session;
        this.multipartService = multipartService;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        Object bucket;
        ArrayList<Path> containers = new ArrayList<Path>();
        for (Path file : files.keySet()) {
            if (this.containerService.isContainer(file)) {
                containers.add(file);
                continue;
            }
            callback.delete(file);
            bucket = this.containerService.getContainer(file);
            if (file.getType().contains(AbstractPath.Type.upload)) {
                try {
                    this.multipartService.delete(new MultipartUpload(file.attributes().getVersionId(), bucket.isRoot() ? "" : bucket.getName(), this.containerService.getKey(file)));
                }
                catch (NotfoundException ignored) {
                    log.warn(String.format("Ignore failure deleting multipart upload %s", file));
                }
                continue;
            }
            try {
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).deleteVersionedObject(file.attributes().getVersionId(), bucket.isRoot() ? "" : bucket.getName(), this.containerService.getKey(file));
            }
            catch (ServiceException e) {
                throw new S3ExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
        for (Path file : containers) {
            callback.delete(file);
            try {
                bucket = this.containerService.getContainer(file).getName();
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).deleteBucket((String)bucket);
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).getRegionEndpointCache().removeRegionForBucketName((String)bucket);
            }
            catch (ServiceException e) {
                throw new S3ExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
    }
}

