/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3EncryptionFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3MetadataFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3StorageClassFeature;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Object;

public class S3CopyFeature
implements Copy {
    private static final Logger log = LogManager.getLogger(S3CopyFeature.class);
    private final S3Session session;
    private final PathContainerService containerService;
    private final S3AccessControlListFeature acl;

    public S3CopyFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.acl = acl;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        if (null == status.getStorageClass()) {
            status.setStorageClass(new S3StorageClassFeature(this.session, this.acl).getClass(source));
        }
        if (Encryption.Algorithm.NONE == status.getEncryption()) {
            status.setEncryption(new S3EncryptionFeature(this.session, this.acl).getEncryption(source));
        }
        if (Acl.EMPTY == status.getAcl()) {
            try {
                Acl list = this.acl.getPermission(source);
                if (list.isEditable()) {
                    status.setAcl(list);
                }
            }
            catch (AccessDeniedException | InteroperabilityException e) {
                log.warn(String.format("Ignore failure %s", e));
            }
        }
        S3Object destination = new S3WriteFeature(this.session, this.acl).getDetails(target, status);
        destination.setAcl(this.acl.toAcl(status.getAcl()));
        Path bucket = this.containerService.getContainer(target);
        destination.setBucketName(bucket.isRoot() ? "" : bucket.getName());
        destination.replaceAllMetadata(new HashMap<String, String>(new S3MetadataFeature(this.session, this.acl).getMetadata(source)));
        String versionId = this.copy(source, destination, status, listener);
        return target.withAttributes(new PathAttributes(source.attributes()).withVersionId(versionId));
    }

    protected String copy(Path source, S3Object destination, TransferStatus status, StreamListener listener) throws BackgroundException {
        try {
            Path bucket = this.containerService.getContainer(source);
            Map stringObjectMap = ((RequestEntityRestStorageService)((Object)this.session.getClient())).copyVersionedObject(source.attributes().getVersionId(), bucket.isRoot() ? RequestEntityRestStorageService.findBucketInHostname(this.session.getHost()) : bucket.getName(), this.containerService.getKey(source), destination.getBucketName(), destination, false);
            listener.sent(status.getLength());
            Map complete = (Map)stringObjectMap.get("__complete__");
            return (String)complete.get("x-amz-version-id");
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source) && !this.containerService.isContainer(target);
    }
}

