/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class S3BulkTransferAccelerationFeature
implements Bulk<Void> {
    private static final Logger log = LogManager.getLogger(S3BulkTransferAccelerationFeature.class);
    private final S3Session session;
    private final TransferAcceleration accelerationService;
    private final PathContainerService containerService;

    public S3BulkTransferAccelerationFeature(S3Session session) {
        this(session, (TransferAcceleration)session.getFeature(TransferAcceleration.class));
    }

    public S3BulkTransferAccelerationFeature(S3Session session, TransferAcceleration accelerationService) {
        this.session = session;
        this.accelerationService = accelerationService;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public Void pre(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        this.configure(files, callback, true);
        return null;
    }

    public void post(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        this.configure(files, callback, false);
    }

    public Bulk<Void> withDelete(Delete delete) {
        return this;
    }

    private void configure(Map<TransferItem, TransferStatus> files, ConnectionCallback callback, boolean enabled) throws BackgroundException {
        HashSet<Path> buckets = new HashSet<Path>();
        for (TransferItem file : files.keySet()) {
            Path bucket = this.containerService.getContainer(file.remote);
            if (bucket.isRoot()) continue;
            buckets.add(bucket);
        }
        for (Path bucket : buckets) {
            if (enabled) {
                try {
                    if (this.accelerate(bucket, callback)) {
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Tunnel upload for file %s through accelerated endpoint %s", bucket, this.accelerationService));
                        }
                        this.accelerationService.configure(true, bucket);
                        break;
                    }
                    log.warn(String.format("Transfer acceleration disabled for %s", bucket));
                }
                catch (AccessDeniedException | InteroperabilityException | NotfoundException e) {
                    log.warn(String.format("Ignore failure reading S3 accelerate configuration. %s", e.getMessage()));
                }
                continue;
            }
            this.accelerationService.configure(false, bucket);
        }
    }

    private boolean accelerate(Path bucket, ConnectionCallback prompt) throws BackgroundException {
        switch (this.session.getSignatureVersion()) {
            case AWS2: {
                return false;
            }
        }
        if (this.accelerationService.getStatus(bucket)) {
            log.info(String.format("S3 transfer acceleration enabled for file %s", bucket));
            return true;
        }
        if (new HostPreferences(this.session.getHost()).getBoolean("s3.accelerate.prompt") && this.accelerationService.prompt(this.session.getHost(), bucket, prompt)) {
            log.info(String.format("S3 transfer acceleration enabled for file %s", bucket));
            return true;
        }
        return false;
    }
}

