/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.utils.ServiceUtils;

public class S3BucketRegionRedirectStrategy
extends DefaultRedirectStrategy {
    private static final Logger log = LogManager.getLogger(S3BucketRegionRedirectStrategy.class);
    private final RequestEntityRestStorageService service;
    private final Host host;
    private final RequestEntityRestStorageService authorizer;

    public S3BucketRegionRedirectStrategy(RequestEntityRestStorageService service, Host host, RequestEntityRestStorageService authorizer) {
        this.service = service;
        this.host = host;
        this.authorizer = authorizer;
    }

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        if (response.containsHeader("x-amz-bucket-region")) {
            if (new HostPreferences(this.host).getBoolean("s3.bucket.virtualhost.disable")) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Virtual host style requests are disabled but received redirect response %s with x-amz-bucket-region %s", response, response.getFirstHeader("x-amz-bucket-region")));
                }
                throw new RedirectException(response.getFirstHeader("x-amz-bucket-region").getValue());
            }
            Header header = response.getFirstHeader("x-amz-bucket-region");
            if (log.isWarnEnabled()) {
                log.warn(String.format("Received redirect response %s with %s", response, header));
            }
            String region = header.getValue();
            String uri = StringUtils.replaceEach((String)request.getRequestLine().getUri(), (String[])((String[])this.host.getProtocol().getRegions().stream().map(Location.Name::getIdentifier).toArray(String[]::new)), (String[])((String[])this.host.getProtocol().getRegions().stream().map(location -> region).toArray(String[]::new)));
            HttpUriRequest redirect = RequestBuilder.copy((HttpRequest)request).setUri(uri).build();
            if (log.isWarnEnabled()) {
                log.warn(String.format("Retry request with URI %s", redirect.getURI()));
            }
            String bucketName = ServiceUtils.findBucketNameInHostOrPath((URI)redirect.getURI(), (String)RequestEntityRestStorageService.createRegionSpecificEndpoint(this.host, region));
            if (log.isDebugEnabled()) {
                log.debug(String.format("Determined bucket %s from request %s", bucketName, request));
            }
            try {
                this.authorizer.authorizeHttpRequest(bucketName, redirect, context, null);
            }
            catch (ServiceException e) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Failure %s authorizing request %s", new Object[]{e, request}));
                }
                throw new RedirectException(e.getMessage(), (Throwable)e);
            }
            if (bucketName != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Cache region %s for bucket %s", region, bucketName));
                }
                this.service.getRegionEndpointCache().putRegionForBucketName(bucketName, region);
            }
            return redirect;
        }
        return super.getRedirect(request, response, context);
    }
}

