/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.RootListService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3Session;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Bucket;

public class S3BucketListService
implements RootListService {
    private static final Logger log = LogManager.getLogger(S3BucketListService.class);
    private final S3Session session;
    private final S3LocationFeature.S3Region region;

    public S3BucketListService(S3Session session) {
        this(session, new S3LocationFeature.S3Region(null));
    }

    public S3BucketListService(S3Session session, S3LocationFeature.S3Region region) {
        this.session = session;
        this.region = region;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("List containers for %s", new Object[]{this.session}));
        }
        try {
            AttributedList buckets = new AttributedList();
            for (S3Bucket b : ((RequestEntityRestStorageService)((Object)this.session.getClient())).listAllBuckets()) {
                Path bucket = new Path(PathNormalizer.normalize((String)b.getName()), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
                if (b.getOwner() != null) {
                    bucket.attributes().setOwner(b.getOwner().getId());
                }
                bucket.attributes().setCreationDate(b.getCreationDate().getTime());
                if (b.isLocationKnown()) {
                    bucket.attributes().setRegion(b.getLocation());
                }
                if (this.region.getIdentifier() != null) {
                    String location = !b.isLocationKnown() ? ((Location)this.session.getFeature(Location.class)).getLocation(bucket).getIdentifier() : b.getLocation();
                    if (!StringUtils.equals((CharSequence)location, (CharSequence)this.region.getIdentifier())) {
                        log.warn(String.format("Skip bucket %s in region %s", bucket, location));
                        continue;
                    }
                    bucket.attributes().setRegion(location);
                }
                buckets.add((Referenceable)bucket);
                listener.chunk(directory, buckets);
            }
            return buckets;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }
}

