/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.utils.ServiceUtils;

public class S3BucketCreateService {
    private static final Logger log = LogManager.getLogger(S3BucketCreateService.class);
    private final S3Session session;
    private final PathContainerService containerService;

    public S3BucketCreateService(S3Session session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public void create(Path bucket, String region) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Create bucket %s in region %s", bucket, region));
        }
        if (!new HostPreferences(this.session.getHost()).getBoolean("s3.bucket.virtualhost.disable") && !ServiceUtils.isBucketNameValidDNSName((String)bucket.getName())) {
            throw new InteroperabilityException(LocaleFactory.localizedString((String)"Bucket name is not DNS compatible", (String)"S3"));
        }
        AccessControlList acl = new HostPreferences(this.session.getHost()).getProperty("s3.acl.default").equals("public-read") ? AccessControlList.REST_CANNED_PUBLIC_READ : AccessControlList.REST_CANNED_PRIVATE;
        try {
            if (StringUtils.isNotBlank((CharSequence)region)) {
                if (S3Session.isAwsHostname(this.session.getHost().getHostname())) {
                    this.session.getHost().setProperty("s3.location", region);
                }
            } else {
                log.warn("Missing region for bucket location");
            }
            ((RequestEntityRestStorageService)((Object)this.session.getClient())).createBucket(URIEncoder.encode((String)this.containerService.getContainer(bucket).getName()), "us-east-1".equals(region) ? "US" : region, acl);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot create folder {0}", e, bucket);
        }
    }
}

