/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.CancellingListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesAdapter;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.StorageObject;

public class S3AttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = LogManager.getLogger(S3AttributesFinderFeature.class);
    private final S3Session session;
    private final S3AccessControlListFeature acl;
    private final PathContainerService containerService;

    public S3AttributesFinderFeature(S3Session session, S3AccessControlListFeature acl) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.acl = acl;
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        if (this.containerService.isContainer(file)) {
            PathAttributes attributes = new PathAttributes();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Read location for bucket %s", file));
            }
            attributes.setRegion(new S3LocationFeature(this.session, ((RequestEntityRestStorageService)((Object)this.session.getClient())).getRegionEndpointCache()).getLocation(file).getIdentifier());
            return attributes;
        }
        if (file.getType().contains(AbstractPath.Type.upload)) {
            Write.Append append = new S3WriteFeature(this.session, this.acl).append(file, new TransferStatus());
            if (append.append) {
                return new PathAttributes().withSize(append.size.longValue());
            }
            throw new NotfoundException(file.getAbsolute());
        }
        try {
            PathAttributes attr;
            Path bucket = this.containerService.getContainer(file);
            try {
                attr = new S3AttributesAdapter().toAttributes((StorageObject)((RequestEntityRestStorageService)((Object)this.session.getClient())).getVersionedObjectDetails(file.attributes().getVersionId(), bucket.isRoot() ? "" : bucket.getName(), this.containerService.getKey(file)));
            }
            catch (ServiceException e) {
                switch (e.getResponseCode()) {
                    case 405: {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Mark file %s as delete marker", file));
                        }
                        PathAttributes attr2 = new PathAttributes();
                        attr2.setCustom(Collections.singletonMap("delete_marker", Boolean.TRUE.toString()));
                        attr2.setDuplicate(true);
                        return attr2;
                    }
                }
                throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            }
            if (StringUtils.isNotBlank((CharSequence)attr.getVersionId())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Determine if %s is latest version for %s", attr.getVersionId(), file));
                }
                try {
                    String latest = new S3AttributesAdapter().toAttributes(((RequestEntityRestStorageService)((Object)this.session.getClient())).getObjectDetails(bucket.isRoot() ? "" : bucket.getName(), this.containerService.getKey(file))).getVersionId();
                    if (null != latest) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Found later version %s for %s", latest, file));
                        }
                        attr.setDuplicate(!latest.equals(attr.getVersionId()));
                    }
                }
                catch (ServiceException e) {
                    BackgroundException failure = new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
                    if (failure instanceof NotfoundException) {
                        attr.setDuplicate(true);
                    }
                    throw failure;
                }
            }
            return attr;
        }
        catch (NotfoundException e) {
            if (file.isDirectory()) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Search for common prefix %s", file));
                }
                try {
                    new S3ObjectListService(this.session, this.acl).list(file, (ListProgressListener)new CancellingListProgressListener(), String.valueOf('/'), 1);
                }
                catch (ListCanceledException l) {
                    return PathAttributes.EMPTY;
                }
                catch (NotfoundException n) {
                    throw e;
                }
                return PathAttributes.EMPTY;
            }
            throw e;
        }
    }
}

