/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.io.Checksum;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;

public class S3AttributesAdapter
implements AttributesAdapter<StorageObject> {
    public PathAttributes toAttributes(StorageObject object) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(object.getContentLength());
        Date lastmodified = object.getLastModifiedDate();
        if (lastmodified != null) {
            attributes.setModificationDate(lastmodified.getTime());
        }
        if (StringUtils.isNotBlank((CharSequence)object.getStorageClass())) {
            attributes.setStorageClass(object.getStorageClass());
        } else if (object.containsMetadata("storage-class")) {
            attributes.setStorageClass(object.getMetadata("storage-class").toString());
        }
        if (StringUtils.isNotBlank((CharSequence)object.getETag())) {
            attributes.setETag(StringUtils.remove((String)object.getETag(), (char)'\"'));
        }
        attributes.setChecksum(Checksum.parse((String)object.getETag()));
        if (object instanceof S3Object) {
            attributes.setVersionId(((S3Object)object).getVersionId());
        }
        if (object.containsMetadata("server-side-encryption-aws-kms-key-id")) {
            attributes.setEncryption(new Encryption.Algorithm(object.getServerSideEncryptionAlgorithm(), object.getMetadata("server-side-encryption-aws-kms-key-id").toString()){

                public String getDescription() {
                    return String.format("SSE-KMS (%s)", this.key);
                }
            });
        } else if (null != object.getServerSideEncryptionAlgorithm()) {
            attributes.setEncryption(new Encryption.Algorithm(object.getServerSideEncryptionAlgorithm(), null){

                public String getDescription() {
                    return "SSE-S3 (AES-256)";
                }
            });
        }
        if (!object.getModifiableMetadata().isEmpty()) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            Map source = object.getModifiableMetadata();
            for (Map.Entry entry : source.entrySet()) {
                metadata.put((String)entry.getKey(), entry.getValue().toString());
            }
            attributes.setMetadata(metadata);
            if (object.containsMetadata("Mtime")) {
                attributes.setModificationDate(Double.valueOf(object.getMetadata("Mtime").toString()).longValue());
            }
        }
        return attributes;
    }
}

