/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.shared.DefaultAclFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.CanonicalGrantee;
import org.jets3t.service.acl.EmailAddressGrantee;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.OwnershipControlsConfig;
import org.jets3t.service.model.StorageOwner;

public class S3AccessControlListFeature
extends DefaultAclFeature
implements AclPermission {
    private static final Logger log = LogManager.getLogger(S3AccessControlListFeature.class);
    public static final Set<? extends Acl> CANNED_LIST = new LinkedHashSet<Acl>(Arrays.asList(Acl.CANNED_PRIVATE, Acl.CANNED_PUBLIC_READ, Acl.CANNED_PUBLIC_READ_WRITE, Acl.CANNED_BUCKET_OWNER_READ, Acl.CANNED_BUCKET_OWNER_FULLCONTROL, Acl.CANNED_AUTHENTICATED_READ));
    private final S3Session session;
    private final PathContainerService containerService;
    private final LRUCache<Path, Acl> cache = LRUCache.build((long)10L);

    public S3AccessControlListFeature(S3Session session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    private boolean isBucketOwnerEnforced(Path bucket) throws BackgroundException {
        try {
            OwnershipControlsConfig controls = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getBucketOwnershipControls(bucket.isRoot() ? "" : bucket.getName());
            for (OwnershipControlsConfig.Rule rule : controls.getRules()) {
                if (rule.getOwnership() != OwnershipControlsConfig.ObjectOwnership.BUCKET_OWNER_ENFORCED) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Bucket owner enforced policy set with disabled ACLs for bucket %s", bucket));
                }
                return true;
            }
        }
        catch (ServiceException e) {
            try {
                throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, bucket);
            }
            catch (NotfoundException rule) {
            }
            catch (AccessDeniedException | InteroperabilityException l) {
                log.warn(String.format("Missing permission to read bucket ownership configuration for %s %s", bucket.getName(), e.getMessage()));
            }
        }
        return false;
    }

    public Acl getDefault(Path file, Local local) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        if (this.cache.contains((Object)bucket)) {
            return (Acl)this.cache.get((Object)bucket);
        }
        if (this.isBucketOwnerEnforced(bucket)) {
            this.cache.put((Object)bucket, (Object)Acl.EMPTY);
            return Acl.EMPTY;
        }
        Acl preference = Acl.toAcl((String)new HostPreferences(this.session.getHost()).getProperty("s3.acl.default"));
        this.cache.put((Object)bucket, (Object)preference);
        return preference;
    }

    public Acl getDefault(EnumSet<AbstractPath.Type> type) {
        return Acl.toAcl((String)new HostPreferences(this.session.getHost()).getProperty("s3.acl.default"));
    }

    public Acl getPermission(Path file) throws BackgroundException {
        try {
            if (file.getType().contains(AbstractPath.Type.upload)) {
                return Acl.EMPTY;
            }
            Path bucket = this.containerService.getContainer(file);
            Acl acl = this.containerService.isContainer(file) ? this.toAcl(((RequestEntityRestStorageService)((Object)this.session.getClient())).getBucketAcl(bucket.isRoot() ? "" : bucket.getName())) : (file.isFile() || file.isPlaceholder() ? this.toAcl(((RequestEntityRestStorageService)((Object)this.session.getClient())).getVersionedObjectAcl(file.attributes().getVersionId(), bucket.isRoot() ? "" : bucket.getName(), this.containerService.getKey(file))) : Acl.EMPTY);
            if (this.isBucketOwnerEnforced(bucket)) {
                acl.setEditable(false);
            }
            return acl;
        }
        catch (ServiceException e) {
            BackgroundException failure = new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            if (file.isPlaceholder() && failure instanceof NotfoundException) {
                return Acl.EMPTY;
            }
            if (failure instanceof InteroperabilityException) {
                return Acl.EMPTY;
            }
            throw failure;
        }
    }

    public void setPermission(Path file, Acl acl) throws BackgroundException {
        try {
            AccessControlList list = this.toAcl(acl);
            Path bucket = this.containerService.getContainer(file);
            if (this.containerService.isContainer(file)) {
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).putBucketAcl(bucket.isRoot() ? "" : bucket.getName(), list);
            } else if (file.isFile() || file.isPlaceholder()) {
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).putObjectAcl(bucket.isRoot() ? "" : bucket.getName(), this.containerService.getKey(file), list);
            }
        }
        catch (ServiceException e) {
            BackgroundException failure = new S3ExceptionMappingService().map("Cannot change permissions of {0}", e, file);
            if (file.isPlaceholder() && failure instanceof NotfoundException) {
                return;
            }
            throw failure;
        }
    }

    protected AccessControlList toAcl(Acl acl) {
        if (Acl.EMPTY.equals((Object)acl)) {
            return null;
        }
        if (Acl.CANNED_PRIVATE.equals((Object)acl)) {
            return AccessControlList.REST_CANNED_PRIVATE;
        }
        if (Acl.CANNED_BUCKET_OWNER_FULLCONTROL.equals((Object)acl)) {
            return AccessControlList.REST_CANNED_BUCKET_OWNER_FULLCONTROL;
        }
        if (Acl.CANNED_BUCKET_OWNER_READ.equals((Object)acl)) {
            return AccessControlList.REST_CANNED_BUCKET_OWNER_READ;
        }
        if (Acl.CANNED_AUTHENTICATED_READ.equals((Object)acl)) {
            return AccessControlList.REST_CANNED_AUTHENTICATED_READ;
        }
        if (Acl.CANNED_PUBLIC_READ.equals((Object)acl)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ;
        }
        if (Acl.CANNED_PUBLIC_READ_WRITE.equals((Object)acl)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ_WRITE;
        }
        AccessControlList list = new AccessControlList();
        for (Acl.UserAndRole userAndRole : acl.asList()) {
            if (!userAndRole.isValid()) continue;
            if (userAndRole.getUser() instanceof Acl.Owner) {
                list.setOwner(new StorageOwner(userAndRole.getUser().getIdentifier(), userAndRole.getUser().getDisplayName()));
                continue;
            }
            if (userAndRole.getUser() instanceof Acl.EmailUser) {
                list.grantPermission((GranteeInterface)new EmailAddressGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            if (userAndRole.getUser() instanceof Acl.GroupUser) {
                if (userAndRole.getUser().getIdentifier().equals("AllUsers")) {
                    list.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, Permission.parsePermission((String)userAndRole.getRole().getName()));
                    continue;
                }
                if (userAndRole.getUser().getIdentifier().equals("AllAuthenticatedUsers")) {
                    list.grantPermission((GranteeInterface)GroupGrantee.AUTHENTICATED_USERS, Permission.parsePermission((String)userAndRole.getRole().getName()));
                    continue;
                }
                list.grantPermission((GranteeInterface)new GroupGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            if (userAndRole.getUser() instanceof Acl.CanonicalUser) {
                list.grantPermission((GranteeInterface)new CanonicalGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            log.warn(String.format("Unsupported user %s", userAndRole.getUser()));
        }
        if (null == list.getOwner()) {
            log.warn(String.format("Missing owner in %s", acl));
            return null;
        }
        return list;
    }

    protected Acl toAcl(AccessControlList list) {
        if (null == list) {
            return Acl.EMPTY;
        }
        if (AccessControlList.REST_CANNED_PRIVATE == list) {
            return Acl.CANNED_PRIVATE;
        }
        if (AccessControlList.REST_CANNED_PUBLIC_READ == list) {
            return Acl.CANNED_PUBLIC_READ;
        }
        if (AccessControlList.REST_CANNED_PUBLIC_READ_WRITE == list) {
            return Acl.CANNED_PUBLIC_READ_WRITE;
        }
        if (AccessControlList.REST_CANNED_AUTHENTICATED_READ == list) {
            return Acl.CANNED_AUTHENTICATED_READ;
        }
        if (AccessControlList.REST_CANNED_BUCKET_OWNER_FULLCONTROL == list) {
            return Acl.CANNED_BUCKET_OWNER_FULLCONTROL;
        }
        if (AccessControlList.REST_CANNED_BUCKET_OWNER_READ == list) {
            return Acl.CANNED_BUCKET_OWNER_READ;
        }
        Acl.Owner owner = new Acl.Owner(list.getOwner().getId(), list.getOwner().getDisplayName());
        if (!owner.isValid()) {
            log.warn(String.format("Invalid owner %s in ACL", list.getOwner()));
            return Acl.EMPTY;
        }
        Acl acl = new Acl((Acl.User)owner, new Acl.Role[]{new Acl.Role(Permission.PERMISSION_FULL_CONTROL.toString(), false)});
        for (GrantAndPermission grant : list.getGrantAndPermissions()) {
            Acl.Role role = new Acl.Role(grant.getPermission().toString());
            if (null == grant.getGrantee()) {
                log.warn(String.format("Missing grantee in ACL %s", grant));
                continue;
            }
            if (grant.getGrantee() instanceof CanonicalGrantee) {
                acl.addAll((Acl.User)new Acl.CanonicalUser(grant.getGrantee().getIdentifier(), ((CanonicalGrantee)grant.getGrantee()).getDisplayName(), false), new Acl.Role[]{role});
                continue;
            }
            if (grant.getGrantee() instanceof EmailAddressGrantee) {
                acl.addAll((Acl.User)new Acl.EmailUser(grant.getGrantee().getIdentifier()), new Acl.Role[]{role});
                continue;
            }
            if (!(grant.getGrantee() instanceof GroupGrantee)) continue;
            if (grant.getGrantee().getIdentifier().equals(GroupGrantee.ALL_USERS.getIdentifier())) {
                acl.addAll((Acl.User)new Acl.GroupUser("AllUsers"), new Acl.Role[]{role});
                continue;
            }
            if (grant.getGrantee().getIdentifier().equals(GroupGrantee.AUTHENTICATED_USERS.getIdentifier())) {
                acl.addAll((Acl.User)new Acl.GroupUser("AllAuthenticatedUsers"), new Acl.Role[]{role});
                continue;
            }
            acl.addAll((Acl.User)new Acl.GroupUser(grant.getGrantee().getIdentifier()), new Acl.Role[]{role});
        }
        return acl;
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Arrays.asList(new Acl.Role(Permission.PERMISSION_FULL_CONTROL.toString()), new Acl.Role(Permission.PERMISSION_READ.toString()), new Acl.Role(Permission.PERMISSION_WRITE.toString()), new Acl.Role(Permission.PERMISSION_READ_ACP.toString()), new Acl.Role(Permission.PERMISSION_WRITE_ACP.toString()));
    }

    public List<Acl.User> getAvailableAclUsers() {
        return new ArrayList<Acl.User>(Arrays.asList(new Acl.CanonicalUser(), new Acl.GroupUser("AllAuthenticatedUsers", false){

            public String getPlaceholder() {
                return LocaleFactory.localizedString((String)"http://acs.amazonaws.com/groups/global/AuthenticatedUsers", (String)"S3");
            }
        }, new Acl.GroupUser("AllUsers", false), new Acl.EmailUser(){

            public String getPlaceholder() {
                return LocaleFactory.localizedString((String)"Amazon Customer Email Address", (String)"S3");
            }
        }));
    }
}

