/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.S3BucketRegionRedirectStrategy;
import ch.cyberduck.core.s3.S3HttpRequestRetryHandler;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.s3.S3Session;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;
import org.jets3t.service.model.StorageBucket;
import org.jets3t.service.model.StorageBucketLoggingStatus;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.WebsiteConfig;
import org.jets3t.service.security.AWSSessionCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

public class RequestEntityRestStorageService
extends RestS3Service {
    private static final Logger log = LogManager.getLogger(RequestEntityRestStorageService.class);
    private final S3Session session;
    private final Jets3tProperties properties;

    protected static Jets3tProperties toProperties(Host bookmark, S3Protocol.AuthenticationHeaderSignatureVersion signatureVersion) {
        Jets3tProperties properties = new Jets3tProperties();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Configure for endpoint %s", bookmark));
        }
        properties.setProperty("s3service.enable-storage-classes", String.valueOf(true));
        properties.setProperty("s3service.internal-error-retry-max", String.valueOf(0));
        properties.setProperty("s3service.max-thread-count", String.valueOf(1));
        properties.setProperty("httpclient.proxy-autodetect", String.valueOf(false));
        properties.setProperty("httpclient.retry-max", String.valueOf(0));
        properties.setProperty("storage-service.internal-error-retry-max", String.valueOf(0));
        properties.setProperty("storage-service.request-signature-version", signatureVersion.toString());
        properties.setProperty("storage-service.disable-live-md5", String.valueOf(true));
        properties.setProperty("storage-service.default-region", bookmark.getRegion());
        properties.setProperty("xmlparser.sanitize-listings", String.valueOf(false));
        for (Map.Entry property : bookmark.getProtocol().getProperties().entrySet()) {
            properties.setProperty((String)property.getKey(), (String)property.getValue());
        }
        return properties;
    }

    public RequestEntityRestStorageService(S3Session session, HttpClientBuilder configuration) {
        super(null, new PreferencesUseragentProvider().get(), null, RequestEntityRestStorageService.toProperties(session.getHost(), session.getSignatureVersion()));
        this.session = session;
        this.properties = this.getJetS3tProperties();
        RequestEntityRestStorageService authorizer = this;
        configuration.setRetryHandler((HttpRequestRetryHandler)new S3HttpRequestRetryHandler(session.getHost(), (JetS3tRequestAuthorizer)authorizer, new HostPreferences(session.getHost()).getInteger("http.connections.retry")));
        configuration.setRedirectStrategy((RedirectStrategy)new S3BucketRegionRedirectStrategy(this, session.getHost(), authorizer));
        this.setHttpClient(configuration.build());
    }

    public Jets3tProperties getConfiguration() {
        return this.properties;
    }

    public String getEndpoint() {
        return this.session.getHost().getHostname();
    }

    protected void initializeDefaults() {
    }

    protected HttpClientBuilder initHttpClientBuilder() {
        return null;
    }

    protected void initializeProxy(HttpClientBuilder httpClientBuilder) {
    }

    protected HttpUriRequest setupConnection(String method, String bucketName, String objectKey, Map<String, String> requestParameters) throws S3ServiceException {
        return this.setupConnection(RestStorageService.HTTP_METHOD.valueOf((String)method), bucketName, objectKey, requestParameters);
    }

    public HttpUriRequest setupConnection(RestStorageService.HTTP_METHOD method, String bucketName, String objectKey, Map<String, String> requestParameters) throws S3ServiceException {
        HttpPut request;
        String url;
        Host host = this.session.getHost();
        HostPreferences preferences = new HostPreferences(host);
        String endpoint = host.getHostname();
        if (S3Session.isAwsHostname(host.getHostname(), false)) {
            if (StringUtils.isNotBlank((CharSequence)host.getRegion())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Apply default region %s to endpoint", host.getRegion()));
                }
                endpoint = RequestEntityRestStorageService.createRegionSpecificEndpoint(host, host.getRegion());
            } else if (preferences.getBoolean("s3.transferacceleration.enable")) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Use accelerated endpoint %s", "s3-accelerate.dualstack.amazonaws.com"));
                }
                endpoint = "s3-accelerate.dualstack.amazonaws.com";
            } else if (!(this.getDisableDnsBuckets() || requestParameters != null && requestParameters.containsKey("location") || !StringUtils.isNotBlank((CharSequence)bucketName))) {
                try {
                    Location.Name region = new S3LocationFeature(this.session, this.regionEndpointCache).getLocation(bucketName);
                    if (Location.unknown == region) {
                        log.warn(String.format("Failure determining bucket location for %s", bucketName));
                        endpoint = host.getHostname();
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Determined region %s for bucket %s", region, bucketName));
                        }
                        endpoint = RequestEntityRestStorageService.createRegionSpecificEndpoint(host, region.getIdentifier());
                    }
                }
                catch (BackgroundException e) {
                    log.error(String.format("Failure %s determining bucket location for %s", new Object[]{e, bucketName}));
                    endpoint = RequestEntityRestStorageService.createRegionSpecificEndpoint(host, preferences.getProperty("s3.location"));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set endpoint to %s", endpoint));
        }
        String hostname = endpoint;
        String resource = String.valueOf('/');
        if (!this.getDisableDnsBuckets()) {
            if (StringUtils.isNotBlank((CharSequence)bucketName)) {
                if (ServiceUtils.isBucketNameValidDNSName((String)bucketName)) {
                    hostname = String.format("%s.%s", bucketName, endpoint);
                } else {
                    resource = resource + bucketName + '/';
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)bucketName)) {
            resource = resource + bucketName + '/';
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set hostname to %s", hostname));
        }
        String virtualPath = StringUtils.isNotBlank((CharSequence)host.getProtocol().getContext()) && !Scheme.isURL((String)host.getProtocol().getContext()) ? PathNormalizer.normalize((String)host.getProtocol().getContext()) : "";
        if (objectKey != null) {
            resource = resource + RestUtils.encodeUrlPath((String)objectKey, (String)"/");
        }
        try {
            url = this.addRequestParametersToUrlPath(String.format("%s://%s:%d%s%s", host.getProtocol().getScheme(), hostname, host.getPort(), virtualPath, resource), requestParameters);
        }
        catch (ServiceException e) {
            throw new S3ServiceException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set URL to %s", url));
        }
        switch (method) {
            case PUT: {
                request = new HttpPut(url);
                break;
            }
            case POST: {
                request = new HttpPost(url);
                break;
            }
            case HEAD: {
                request = new HttpHead(url);
                break;
            }
            case GET: {
                request = new HttpGet(url);
                break;
            }
            case DELETE: {
                request = new HttpDelete(url);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unrecognised HTTP method name %s", method));
            }
        }
        if (request.getFirstHeader("Date") == null) {
            request.setHeader("Date", ServiceUtils.formatRfc822Date((Date)this.getCurrentTimeWithOffset()));
        }
        if (preferences.getBoolean("s3.upload.expect-continue") && "PUT".equals(request.getMethod())) {
            request.addHeader("Expect", "100-continue");
        }
        if (preferences.getBoolean("s3.bucket.requesterpays") && S3Session.isAwsHostname(host.getHostname()) && ("GET".equals(request.getMethod()) || "POST".equals(request.getMethod())) && !preferences.getBoolean("s3.bucket.requesterpays")) {
            request.addHeader("x-amz-request-payer", "requester");
        }
        if (this.getProviderCredentials() instanceof AWSSessionCredentials) {
            request.setHeader("x-amz-security-token", ((AWSSessionCredentials)this.getProviderCredentials()).getSessionToken());
        }
        return request;
    }

    protected static String createRegionSpecificEndpoint(Host host, String region) {
        HostPreferences preferences = new HostPreferences(host);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Apply region %s to endpoint", region));
        }
        if (preferences.getBoolean("s3.endpoint.dualstack.enable")) {
            return String.format(preferences.getProperty("s3.endpoint.format.ipv6"), region);
        }
        return String.format(preferences.getProperty("s3.endpoint.format.ipv4"), region);
    }

    protected boolean getDisableDnsBuckets() {
        if (InetAddressUtils.isIPv4Address((String)this.session.getHost().getHostname()) || InetAddressUtils.isIPv6Address((String)this.session.getHost().getHostname())) {
            return true;
        }
        return new HostPreferences(this.session.getHost()).getBoolean("s3.bucket.virtualhost.disable");
    }

    protected boolean isTargettingGoogleStorageService() {
        return this.session.getHost().getHostname().equals(Constants.GS_DEFAULT_HOSTNAME);
    }

    protected StorageBucket createBucketImpl(String bucketName, String location, AccessControlList acl, Map<String, Object> headers) throws ServiceException {
        return super.createBucketImpl(bucketName, location, acl, headers);
    }

    public void putObjectWithRequestEntityImpl(String bucketName, StorageObject object, HttpEntity requestEntity, Map<String, String> requestParams) throws ServiceException {
        super.putObjectWithRequestEntityImpl(bucketName, object, requestEntity, requestParams);
    }

    public StorageObject getObjectImpl(boolean headOnly, String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd, String versionId, Map<String, Object> requestHeaders, Map<String, String> requestParameters) throws ServiceException {
        return super.getObjectImpl(headOnly, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd, versionId, requestHeaders, requestParameters);
    }

    public void verifyExpectedAndActualETagValues(String expectedETag, StorageObject uploadedObject) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)uploadedObject.getETag())) {
            log.warn("No ETag to verify");
            return;
        }
        super.verifyExpectedAndActualETagValues(expectedETag, uploadedObject);
    }

    protected String getSignatureIdentifier() {
        return this.session.getSignatureIdentifier();
    }

    public String getRestHeaderPrefix() {
        return this.session.getRestHeaderPrefix();
    }

    public String getRestMetadataPrefix() {
        return this.session.getRestMetadataPrefix();
    }

    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return this.session.getXmlResponseSaxParser();
    }

    public void setBucketLoggingStatusImpl(String bucketName, StorageBucketLoggingStatus status) throws ServiceException {
        super.setBucketLoggingStatusImpl(bucketName, status);
    }

    public StorageBucketLoggingStatus getBucketLoggingStatusImpl(String bucketName) throws ServiceException {
        return super.getBucketLoggingStatusImpl(bucketName);
    }

    public WebsiteConfig getWebsiteConfigImpl(String bucketName) throws ServiceException {
        return super.getWebsiteConfigImpl(bucketName);
    }

    public void setWebsiteConfigImpl(String bucketName, WebsiteConfig config) throws ServiceException {
        super.setWebsiteConfigImpl(bucketName, config);
    }

    public void deleteWebsiteConfigImpl(String bucketName) throws ServiceException {
        super.deleteWebsiteConfigImpl(bucketName);
    }

    public void authorizeHttpRequest(String bucketName, HttpUriRequest httpMethod, HttpContext context, String forceRequestSignatureVersion) throws ServiceException {
        if (forceRequestSignatureVersion != null) {
            S3Protocol.AuthenticationHeaderSignatureVersion authenticationHeaderSignatureVersion = S3Protocol.AuthenticationHeaderSignatureVersion.valueOf(StringUtils.remove((String)forceRequestSignatureVersion, (String)"-"));
            log.warn(String.format("Switched authentication signature version to %s", forceRequestSignatureVersion));
            this.session.setSignatureVersion(authenticationHeaderSignatureVersion);
        }
        super.authorizeHttpRequest(bucketName, httpMethod, context, forceRequestSignatureVersion);
    }

    public HttpResponse performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, Object> requestHeaders, int[] expectedStatusCodes) throws ServiceException {
        return super.performRestGet(bucketName, objectKey, requestParameters, requestHeaders, expectedStatusCodes);
    }

    protected boolean isXmlContentType(String contentType) {
        if (null == contentType) {
            return false;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/xml")) {
            return true;
        }
        return StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"text/xml");
    }

    public static String findBucketInHostname(Host host) {
        if (StringUtils.isBlank((CharSequence)host.getProtocol().getDefaultHostname())) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("No default hostname set in %s", host.getProtocol()));
            }
            return null;
        }
        String hostname = host.getHostname();
        if (hostname.equals(host.getProtocol().getDefaultHostname())) {
            return null;
        }
        if (hostname.endsWith(host.getProtocol().getDefaultHostname())) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Find bucket name in %s", hostname));
            }
            return ServiceUtils.findBucketNameInHostname((String)hostname, (String)host.getProtocol().getDefaultHostname());
        }
        return null;
    }
}

