/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.restore;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.auth.AWSCredentialsConfigurator;
import ch.cyberduck.core.aws.AmazonServiceExceptionMappingService;
import ch.cyberduck.core.aws.CustomClientConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConflictException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Restore;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GlacierJobParameters;
import com.amazonaws.services.s3.model.RestoreObjectRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Glacier
implements Restore {
    private static final Logger log = LogManager.getLogger(Glacier.class);
    private final S3Session session;
    private final ClientConfiguration configuration;
    private final Location locationFeature;

    public Glacier(S3Session session, X509TrustManager trust, X509KeyManager key) {
        this.session = session;
        Host bookmark = session.getHost();
        this.configuration = new CustomClientConfiguration(bookmark, new ThreadLocalHostnameDelegatingTrustManager(trust, bookmark.getHostname()), key);
        this.locationFeature = (Location)session.getFeature(Location.class);
    }

    public void restore(Path file, LoginCallback prompt) throws BackgroundException {
        Path container = ((PathContainerService)this.session.getFeature(PathContainerService.class)).getContainer(file);
        try {
            try {
                AmazonS3 client = this.client(container);
                client.restoreObjectV2(new RestoreObjectRequest(container.getName(), ((PathContainerService)this.session.getFeature(PathContainerService.class)).getKey(file)).withVersionId(file.attributes().getVersionId()).withExpirationInDays(new HostPreferences(this.session.getHost()).getInteger("s3.glacier.restore.expiration.days")).withGlacierJobParameters(new GlacierJobParameters().withTier(new HostPreferences(this.session.getHost()).getProperty("s3.glacier.restore.tier"))));
            }
            catch (AmazonClientException e) {
                throw new AmazonServiceExceptionMappingService().map("Failure to write attributes of {0}", e, file);
            }
        }
        catch (ConflictException e) {
            log.warn(String.format("Restore for %s already in progress %s", new Object[]{file, e}));
        }
    }

    public boolean isRestorable(Path file) {
        return StringUtils.equals((CharSequence)"GLACIER", (CharSequence)file.attributes().getStorageClass()) || StringUtils.equals((CharSequence)"DEEP_ARCHIVE", (CharSequence)file.attributes().getStorageClass());
    }

    private AmazonS3 client(Path container) throws BackgroundException {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(AWSCredentialsConfigurator.toAWSCredentialsProvider(((RequestEntityRestStorageService)((Object)this.session.getClient())).getProviderCredentials()))).withClientConfiguration(this.configuration);
        Location.Name region = this.getRegion(container);
        if (S3Session.isAwsHostname(this.session.getHost().getHostname(), false)) {
            if (Location.unknown.equals((Object)region)) {
                builder.withRegion(Regions.DEFAULT_REGION);
            } else {
                builder.withRegion(region.getIdentifier());
            }
        } else {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(new HostUrlProvider(false).get(this.session.getHost()), region.getIdentifier()));
        }
        return (AmazonS3)builder.build();
    }

    protected Location.Name getRegion(Path container) throws BackgroundException {
        return this.locationFeature.getLocation(container);
    }
}

