/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cloudfront;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.s3.S3BucketListService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.shared.OneTimeSchedulerFeature;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudFrontDistributionConfigurationPreloader
extends OneTimeSchedulerFeature<Set<Distribution>> {
    private static final Logger log = LogManager.getLogger(CloudFrontDistributionConfigurationPreloader.class);
    private final S3Session session;

    public CloudFrontDistributionConfigurationPreloader(S3Session session) {
        super(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)));
        this.session = session;
    }

    protected Set<Distribution> operate(PasswordCallback callback, Path file) throws BackgroundException {
        DistributionConfiguration feature = (DistributionConfiguration)this.session.getFeature(DistributionConfiguration.class);
        if (null == feature) {
            return Collections.emptySet();
        }
        AttributedList<Path> containers = new S3BucketListService(this.session, new S3LocationFeature.S3Region(this.session.getHost().getRegion())).list(file, (ListProgressListener)new DisabledListProgressListener());
        LinkedHashSet<Distribution> distributions = new LinkedHashSet<Distribution>();
        for (Path container : containers) {
            for (Distribution.Method method : feature.getMethods(container)) {
                if (Distribution.WEBSITE.equals(method)) continue;
                Distribution distribution = feature.read(container, method, (LoginCallback)new DisabledLoginCallback());
                if (log.isInfoEnabled()) {
                    log.info(String.format("Cache distribution %s", distribution));
                }
                distributions.add(distribution);
            }
        }
        return distributions;
    }
}

