/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.auth;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.CredentialsConfigurator;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginOptions;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jets3t.service.security.ProviderCredentials;

public class AWSCredentialsConfigurator
implements CredentialsConfigurator {
    private static final Logger log = LogManager.getLogger(AWSCredentialsConfigurator.class);
    private final AWSCredentialsProvider[] providers;

    public AWSCredentialsConfigurator(AWSCredentialsProvider ... providers) {
        this.providers = providers;
    }

    public Credentials configure(Host host) {
        Credentials credentials = new Credentials(host.getCredentials());
        if (!credentials.validate(host.getProtocol(), new LoginOptions(host.getProtocol()).password(false))) {
            for (AWSCredentialsProvider provider : this.providers) {
                try {
                    AWSCredentials c = provider.getCredentials();
                    credentials.setUsername(c.getAWSAccessKeyId());
                    credentials.setPassword(c.getAWSSecretKey());
                    if (!(c instanceof AWSSessionCredentials)) break;
                    credentials.setToken(((AWSSessionCredentials)c).getSessionToken());
                    break;
                }
                catch (SdkClientException e) {
                    log.debug(String.format("Ignore failure loading credentials from provider %s", provider));
                }
            }
        }
        return credentials;
    }

    public CredentialsConfigurator reload() {
        for (AWSCredentialsProvider provider : this.providers) {
            provider.refresh();
        }
        return this;
    }

    public static AWSCredentialsProvider toAWSCredentialsProvider(final ProviderCredentials credentials) {
        return credentials instanceof org.jets3t.service.security.AWSSessionCredentials ? new AWSSessionCredentialsProvider(){

            public AWSSessionCredentials getCredentials() {
                return new AWSSessionCredentials(){

                    public String getSessionToken() {
                        return ((org.jets3t.service.security.AWSSessionCredentials)credentials).getSessionToken();
                    }

                    public String getAWSAccessKeyId() {
                        return credentials.getAccessKey();
                    }

                    public String getAWSSecretKey() {
                        return credentials.getSecretKey();
                    }
                };
            }

            public void refresh() {
            }
        } : new AWSStaticCredentialsProvider(new AWSCredentials(){

            public String getAWSAccessKeyId() {
                return credentials.getAccessKey();
            }

            public String getAWSSecretKey() {
                return credentials.getSecretKey();
            }
        });
    }
}

