/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.threading;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.BackgroundExecutor;
import ch.cyberduck.core.threading.DefaultBackgroundExecutor;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.ConnectCallback;
import ch.iterate.mountainduck.fs.FilesystemAlertCallback;
import ch.iterate.mountainduck.fs.FilesystemController;
import ch.iterate.mountainduck.fs.NotificationServiceAlertCallback;
import ch.iterate.mountainduck.threading.FilesystemWorkerBackgroundAction;
import ch.iterate.mountainduck.threading.WorkerExecutor;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadedWorkerExecutor
implements WorkerExecutor {
    private static final Logger log = LogManager.getLogger((String)ThreadedWorkerExecutor.class.getName());
    private final BackgroundActionRegistry registry;
    private final BackgroundExecutor executor;
    private final Controller controller;
    private final Host bookmark;
    private final AlertCallback alert;

    public ThreadedWorkerExecutor(Controller controller, Host bookmark, ConnectCallback connect, BackgroundActionRegistry registry) {
        this(controller, bookmark, new FilesystemAlertCallback(new NotificationServiceAlertCallback(), connect), registry);
    }

    public ThreadedWorkerExecutor(Controller controller, Host bookmark, AlertCallback alert, BackgroundActionRegistry registry) {
        this((BackgroundExecutor)new DefaultBackgroundExecutor("fs", PreferencesFactory.get().getInteger("fs.pool.threads")), controller, bookmark, alert, registry);
    }

    public ThreadedWorkerExecutor(BackgroundExecutor executor, Controller controller, Host bookmark, AlertCallback alert, BackgroundActionRegistry registry) {
        this.executor = executor;
        this.controller = controller;
        this.bookmark = bookmark;
        this.alert = alert;
        this.registry = registry;
    }

    @Override
    public <T> Future<T> run(Worker<T> worker, SessionPool pool) throws BackgroundException {
        FilesystemWorkerBackgroundAction<T> action = new FilesystemWorkerBackgroundAction<T>(worker, pool, this.controller, this.alert);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Run action %s", new Object[]{action}));
        }
        return this.executor.execute((Controller)new FilesystemController(this.controller), this.registry, action);
    }

    @Override
    public void shutdown() {
        for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
            if (action == null) continue;
            action.cancel();
        }
        this.executor.shutdown();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThreadedWorkerExecutor{");
        sb.append("controller=").append(this.controller);
        sb.append(", bookmark=").append(this.bookmark);
        sb.append(", executor=").append(this.executor);
        sb.append('}');
        return sb.toString();
    }
}

