/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.threading;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.BackgroundCallable;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.ConnectCallback;
import ch.iterate.mountainduck.fs.FilesystemAlertCallback;
import ch.iterate.mountainduck.fs.FilesystemController;
import ch.iterate.mountainduck.fs.NotificationServiceAlertCallback;
import ch.iterate.mountainduck.threading.FilesystemWorkerBackgroundAction;
import ch.iterate.mountainduck.threading.WorkerExecutor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockingWorkerExecutor
implements WorkerExecutor {
    private static final Logger log = LogManager.getLogger((String)BlockingWorkerExecutor.class.getName());
    private final BackgroundActionRegistry registry;
    private final Controller controller;
    private final Host bookmark;
    private final AlertCallback alert;

    public BlockingWorkerExecutor(Controller controller, Host bookmark, ConnectCallback connect, BackgroundActionRegistry registry) {
        this(controller, bookmark, new FilesystemAlertCallback(new NotificationServiceAlertCallback(), connect), registry);
    }

    public BlockingWorkerExecutor(Controller controller, Host bookmark, AlertCallback alert, BackgroundActionRegistry registry) {
        this.controller = controller;
        this.bookmark = bookmark;
        this.alert = alert;
        this.registry = registry;
    }

    @Override
    public <T> Future<T> run(Worker<T> worker, SessionPool pool) throws BackgroundException {
        FilesystemWorkerBackgroundAction<T> action = new FilesystemWorkerBackgroundAction<T>(worker, pool, this.controller, this.alert);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Run action %s", new Object[]{action}));
        }
        this.registry.add(action);
        try {
            action.init();
            final AtomicReference failure = new AtomicReference();
            BackgroundCallable c = new BackgroundCallable<T>((BackgroundAction)action, (Controller)new FilesystemController(this.controller)){

                protected void failure(Exception trace, Exception e) {
                    super.failure(trace, e);
                    if (e instanceof BackgroundException) {
                        failure.set((BackgroundException)((Object)e));
                    } else {
                        failure.set(new DefaultExceptionMappingService().map((Throwable)e));
                    }
                }
            };
            Object run = c.call();
            BackgroundException e = (BackgroundException)((Object)failure.get());
            if (null == e) {
                Future future = ConcurrentUtils.constantFuture((Object)run);
                return future;
            }
            throw e;
        }
        finally {
            this.registry.remove(action);
        }
    }

    @Override
    public void shutdown() {
        for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
            if (action == null) continue;
            action.cancel();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BlockingWorkerExecutor{");
        sb.append("controller=").append(this.controller);
        sb.append(", bookmark=").append(this.bookmark);
        sb.append('}');
        return sb.toString();
    }
}

