/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.preferences.LocalSupportDirectoryFinderFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferProgress;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.QueueCoalescedCallback;
import ch.iterate.mountainduck.sync.queue.QueueDiscardCallback;
import ch.iterate.mountainduck.sync.queue.QueueErrorCallback;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface SyncQueue {
    public static final Logger log = LogManager.getLogger((String)SyncQueue.class.getName());

    public void purge(Local var1, Path var2) throws BackgroundException;

    public void read(Local var1, Path var2) throws BackgroundException;

    public void read(List<TransferItem> var1, QueueDiscardCallback var2, QueueErrorCallback var3) throws BackgroundException;

    public void write(Local var1, Path var2, Application var3) throws BackgroundException;

    public void write(List<TransferItem> var1, QueueCoalescedCallback var2, QueueDiscardCallback var3, QueueErrorCallback var4, Application var5) throws BackgroundException;

    public void rename(Local var1, Local var2, Path var3, Path var4) throws BackgroundException;

    public void delete(Local var1, Path var2) throws BackgroundException;

    public void delete(List<TransferItem> var1, QueueDiscardCallback var2) throws BackgroundException;

    public void mkdir(Local var1, Path var2) throws BackgroundException;

    public void timestamp(Local var1, Path var2, Long var3) throws BackgroundException;

    public void chmod(Local var1, Path var2, Permission var3) throws BackgroundException;

    public void symlink(Local var1, Local var2, Path var3, Path var4) throws BackgroundException;

    public void lock(Local var1, Path var2) throws BackgroundException;

    public void unlock(Local var1, Path var2, String var3) throws BackgroundException;

    public List<SerializableOperation> find(int var1);

    public boolean contains(Path var1);

    public Set<SerializableOperation> get(Local var1);

    public Status getStatus();

    public Status getStatus(Path var1);

    public boolean submit(SerializableOperation var1);

    public void flush() throws BackgroundException;

    public void close() throws BackgroundException;

    public SyncQueue open() throws BackgroundException;

    default public Future<Boolean> pause(Status cause) {
        return this.pause(cause, null);
    }

    public Future<Boolean> pause(Status var1, BackgroundException var2);

    public Future<Boolean> resume();

    public int size();

    public Stats stats();

    public void beginQueueing(Path var1, Local var2);

    public void endQueueing(Path var1, Local var2);

    public SyncQueue withListener(Listener var1);

    public static void cleanup(Host bookmark) {
        Local directory = SyncQueue.directory(bookmark);
        if (directory.exists()) {
            log.warn(String.format("Delete sync %s for bookmark %s", directory, bookmark));
            try {
                LocalTrashFactory.get().trash(directory);
            }
            catch (AccessDeniedException e) {
                log.warn(String.format("Ignore failure trashing sync directory %s", directory));
            }
        }
    }

    public static Local directory(Host bookmark) {
        return LocalFactory.get((Local)LocalFactory.get((Local)LocalSupportDirectoryFinderFactory.get().find(), (String)PreferencesFactory.get().getProperty("fs.sync.folder.name")), (String)bookmark.getUuid());
    }

    public static enum Status {
        none,
        pausing,
        paused,
        stopped,
        idle,
        busy;

    }

    public static interface Listener {
        public void fileStatusChanged(Set<Path> var1, Operation var2, FileStatusService.Status var3);

        default public void queueStatusChanged(Status status) {
            this.queueStatusChanged(status, null);
        }

        public void queueStatusChanged(Status var1, BackgroundException var2);

        public void transferStatusChanged(TransferProgress var1);
    }

    public static final class Stats {
        public static final Stats IDLE = new Stats(0, 0L);
        public int files;
        public long bytes;

        public Stats(int files, long bytes) {
            this.files = files;
            this.bytes = bytes;
        }

        public Stats combine(Stats other) {
            return new Stats(this.files + other.files, this.bytes + other.bytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats stats = (Stats)o;
            return this.files == stats.files && this.bytes == stats.bytes;
        }

        public int hashCode() {
            return Objects.hash(this.files, this.bytes);
        }
    }
}

