/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.local.Application;
import ch.iterate.mountainduck.sync.queue.Operation;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class SerializableOperation {
    protected Operation operation;
    protected Local local;
    protected Local larg;
    protected Path remote;
    protected Path arg;
    protected PathAttributes attr;
    protected long length = -1L;
    protected Checksum checksum = Checksum.NONE;
    protected Application application = Application.notfound;

    public SerializableOperation() {
    }

    public SerializableOperation(Operation operation, Local local, Path remote) {
        this.operation = operation;
        this.local = local;
        this.remote = remote;
    }

    public SerializableOperation(Operation operation, Local local, Path remote, PathAttributes attr) {
        this.operation = operation;
        this.local = local;
        this.remote = remote;
        this.attr = attr;
    }

    public SerializableOperation(Operation operation, Local local, Local larg, Path remote, Path arg) {
        this.operation = operation;
        this.local = local;
        this.larg = larg;
        this.remote = remote;
        this.arg = arg;
    }

    public SerializableOperation(Operation operation, Local local, Local larg, Path remote, Path arg, PathAttributes attr) {
        this.operation = operation;
        this.local = local;
        this.larg = larg;
        this.remote = remote;
        this.arg = arg;
        this.attr = attr;
    }

    public SerializableOperation(Operation operation, Local local, Local larg, Path remote, Path arg, PathAttributes attr, long length) {
        this.operation = operation;
        this.local = local;
        this.larg = larg;
        this.remote = remote;
        this.arg = arg;
        this.attr = attr;
        this.length = length;
    }

    public SerializableOperation(Operation operation, Local local, Local larg, Path remote, Path arg, PathAttributes attr, long length, Checksum checksum, Application application) {
        this.operation = operation;
        this.local = local;
        this.larg = larg;
        this.remote = remote;
        this.arg = arg;
        this.attr = attr;
        this.length = length;
        this.checksum = checksum;
        this.application = application;
    }

    public SerializableOperation(SerializableOperation other) {
        this.operation = other.operation;
        this.local = other.local;
        this.larg = other.larg;
        this.remote = other.remote;
        this.arg = other.arg;
        this.attr = other.attr;
        this.length = other.length;
        this.checksum = other.checksum;
        this.application = other.application;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Local getLocal() {
        return this.local;
    }

    public SerializableOperation withLocal(Local local) {
        this.local = local;
        return this;
    }

    public Path getRemote() {
        return this.remote;
    }

    public SerializableOperation withRemote(Path remote) {
        this.remote = remote;
        return this;
    }

    public Path getArg() {
        return this.arg;
    }

    public Local getLocalArg() {
        return this.larg;
    }

    public PathAttributes getAttr() {
        return this.attr;
    }

    public SerializableOperation withLength(long length) {
        this.length = length;
        return this;
    }

    public long getLength() {
        return this.length;
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    public SerializableOperation withChecksum(Checksum checksum) {
        this.checksum = checksum;
        return this;
    }

    public Application getApplication() {
        return this.application;
    }

    public SerializableOperation withApplication(Application application) {
        this.application = application;
        return this;
    }

    protected byte[] toBinary(NSDictionary dict) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryPropertyListWriter.write((OutputStream)out, (NSObject)dict);
        return out.toByteArray();
    }

    protected String toXml(NSDictionary dict) throws IOException {
        return dict.toXMLPropertyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializableOperation operation1 = (SerializableOperation)o;
        return this.length == operation1.length && this.operation == operation1.operation && Objects.equals(this.local, operation1.local) && Objects.equals(this.larg, operation1.larg) && Objects.equals(this.remote, operation1.remote) && Objects.equals(this.arg, operation1.arg) && Objects.equals(this.attr, operation1.attr) && Objects.equals(this.checksum, operation1.checksum);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.local, this.larg, this.remote, this.arg, this.attr, this.length, this.checksum});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SerializableOperation{");
        sb.append("operation=").append((Object)this.operation);
        sb.append(", local=").append(this.local);
        sb.append(", larg=").append(this.larg);
        sb.append(", remote=").append(this.remote);
        sb.append(", arg=").append(this.arg);
        sb.append(", attr=").append(this.attr);
        sb.append(", length=").append(this.length);
        sb.append(", checksum=").append(this.checksum);
        sb.append(", application=").append(this.application);
        sb.append('}');
        return sb.toString();
    }
}

