/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.iterate.mountainduck.sync.metadata.FileMetadataReader;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class XmlPlistFileMetadataReader
implements FileMetadataReader<NSDictionary> {
    private static final Logger log = LogManager.getLogger((String)XmlPlistFileMetadataReader.class.getName());

    @Override
    public NSDictionary read(ByteBuffer value) {
        try {
            if (null == value) {
                return null;
            }
            NSObject dictionary = XMLPropertyListParser.parse((byte[])value.array());
            return (NSDictionary)dictionary;
        }
        catch (PropertyListFormatException | IOException | ParseException | ParserConfigurationException | SAXException e) {
            log.warn(String.format("Failure reading extended attributes for %s", value));
            return null;
        }
    }
}

