/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserDefinedFileAttributeViewMetadataStorage
implements MetadataStorage {
    private static final Logger log = LogManager.getLogger((String)UserDefinedFileAttributeViewMetadataStorage.class.getName());

    @Override
    public void set(Local file, MetadataStorage.Key key, ByteBuffer value) throws IOException {
        UserDefinedFileAttributeView view = Files.getFileAttributeView(Paths.get(file.getAbsolute(), new String[0]), UserDefinedFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        if (null == view) {
            throw new IOException(new UnsupportedException());
        }
        view.write(key.toString(), value);
    }

    @Override
    public ByteBuffer get(Local file, MetadataStorage.Key key) throws IOException {
        UserDefinedFileAttributeView view = Files.getFileAttributeView(Paths.get(file.getAbsolute(), new String[0]), UserDefinedFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        if (null == view) {
            throw new IOException(new UnsupportedException());
        }
        try {
            ByteBuffer buffer = ByteBuffer.allocate(view.size(key.toString()));
            view.read(key.toString(), buffer);
            buffer.flip();
            return buffer;
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @Override
    public void delete(Local file, MetadataStorage.Key key) throws IOException {
        UserDefinedFileAttributeView view;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Remove xattr %s for file %s", new Object[]{key, file}));
        }
        if (null == (view = Files.getFileAttributeView(Paths.get(file.getAbsolute(), new String[0]), UserDefinedFileAttributeView.class, LinkOption.NOFOLLOW_LINKS))) {
            throw new IOException(new UnsupportedException());
        }
        view.delete(key.toString());
    }

    @Override
    public void close() {
    }
}

